<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerExtendedResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerExtendedResponse extends AbstractStructArrayBase
{
    /**
     * The CustomerExtendedResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerExtendedResponse[]
     */
    public $CustomerExtendedResponse;
    /**
     * Constructor method for ArrayOfCustomerExtendedResponse
     * @uses ArrayOfCustomerExtendedResponse::setCustomerExtendedResponse()
     * @param \StructType\CustomerExtendedResponse[] $customerExtendedResponse
     */
    public function __construct(array $customerExtendedResponse = array())
    {
        $this
            ->setCustomerExtendedResponse($customerExtendedResponse);
    }
    /**
     * Get CustomerExtendedResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerExtendedResponse[]|null
     */
    public function getCustomerExtendedResponse()
    {
        return isset($this->CustomerExtendedResponse) ? $this->CustomerExtendedResponse : null;
    }
    /**
     * Set CustomerExtendedResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerExtendedResponse[] $customerExtendedResponse
     * @return \ArrayType\ArrayOfCustomerExtendedResponse
     */
    public function setCustomerExtendedResponse(array $customerExtendedResponse = array())
    {
        foreach ($customerExtendedResponse as $arrayOfCustomerExtendedResponseCustomerExtendedResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerExtendedResponseCustomerExtendedResponseItem instanceof \StructType\CustomerExtendedResponse) {
                throw new \InvalidArgumentException(sprintf('The CustomerExtendedResponse property can only contain items of \StructType\CustomerExtendedResponse, "%s" given', is_object($arrayOfCustomerExtendedResponseCustomerExtendedResponseItem) ? get_class($arrayOfCustomerExtendedResponseCustomerExtendedResponseItem) : gettype($arrayOfCustomerExtendedResponseCustomerExtendedResponseItem)), __LINE__);
            }
        }
        if (is_null($customerExtendedResponse) || (is_array($customerExtendedResponse) && empty($customerExtendedResponse))) {
            unset($this->CustomerExtendedResponse);
        } else {
            $this->CustomerExtendedResponse = $customerExtendedResponse;
        }
        return $this;
    }
    /**
     * Add item to CustomerExtendedResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerExtendedResponse $item
     * @return \ArrayType\ArrayOfCustomerExtendedResponse
     */
    public function addToCustomerExtendedResponse(\StructType\CustomerExtendedResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerExtendedResponse) {
            throw new \InvalidArgumentException(sprintf('The CustomerExtendedResponse property can only contain items of \StructType\CustomerExtendedResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerExtendedResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomerExtendedResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomerExtendedResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomerExtendedResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomerExtendedResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomerExtendedResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerExtendedResponse
     */
    public function getAttributeName()
    {
        return 'CustomerExtendedResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCustomerExtendedResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
