<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerEventResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerEventResponse extends AbstractStructArrayBase
{
    /**
     * The CustomerEventResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerEventResponse[]
     */
    public $CustomerEventResponse;
    /**
     * Constructor method for ArrayOfCustomerEventResponse
     * @uses ArrayOfCustomerEventResponse::setCustomerEventResponse()
     * @param \StructType\CustomerEventResponse[] $customerEventResponse
     */
    public function __construct(array $customerEventResponse = array())
    {
        $this
            ->setCustomerEventResponse($customerEventResponse);
    }
    /**
     * Get CustomerEventResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerEventResponse[]|null
     */
    public function getCustomerEventResponse()
    {
        return isset($this->CustomerEventResponse) ? $this->CustomerEventResponse : null;
    }
    /**
     * Set CustomerEventResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerEventResponse[] $customerEventResponse
     * @return \ArrayType\ArrayOfCustomerEventResponse
     */
    public function setCustomerEventResponse(array $customerEventResponse = array())
    {
        foreach ($customerEventResponse as $arrayOfCustomerEventResponseCustomerEventResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerEventResponseCustomerEventResponseItem instanceof \StructType\CustomerEventResponse) {
                throw new \InvalidArgumentException(sprintf('The CustomerEventResponse property can only contain items of \StructType\CustomerEventResponse, "%s" given', is_object($arrayOfCustomerEventResponseCustomerEventResponseItem) ? get_class($arrayOfCustomerEventResponseCustomerEventResponseItem) : gettype($arrayOfCustomerEventResponseCustomerEventResponseItem)), __LINE__);
            }
        }
        if (is_null($customerEventResponse) || (is_array($customerEventResponse) && empty($customerEventResponse))) {
            unset($this->CustomerEventResponse);
        } else {
            $this->CustomerEventResponse = $customerEventResponse;
        }
        return $this;
    }
    /**
     * Add item to CustomerEventResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerEventResponse $item
     * @return \ArrayType\ArrayOfCustomerEventResponse
     */
    public function addToCustomerEventResponse(\StructType\CustomerEventResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerEventResponse) {
            throw new \InvalidArgumentException(sprintf('The CustomerEventResponse property can only contain items of \StructType\CustomerEventResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerEventResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomerEventResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomerEventResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomerEventResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomerEventResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomerEventResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerEventResponse
     */
    public function getAttributeName()
    {
        return 'CustomerEventResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCustomerEventResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
