<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerEventField ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerEventField extends AbstractStructArrayBase
{
    /**
     * The CustomerEventField
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerEventField[]
     */
    public $CustomerEventField;
    /**
     * Constructor method for ArrayOfCustomerEventField
     * @uses ArrayOfCustomerEventField::setCustomerEventField()
     * @param \StructType\CustomerEventField[] $customerEventField
     */
    public function __construct(array $customerEventField = array())
    {
        $this
            ->setCustomerEventField($customerEventField);
    }
    /**
     * Get CustomerEventField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerEventField[]|null
     */
    public function getCustomerEventField()
    {
        return isset($this->CustomerEventField) ? $this->CustomerEventField : null;
    }
    /**
     * Set CustomerEventField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerEventField[] $customerEventField
     * @return \ArrayType\ArrayOfCustomerEventField
     */
    public function setCustomerEventField(array $customerEventField = array())
    {
        foreach ($customerEventField as $arrayOfCustomerEventFieldCustomerEventFieldItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerEventFieldCustomerEventFieldItem instanceof \StructType\CustomerEventField) {
                throw new \InvalidArgumentException(sprintf('The CustomerEventField property can only contain items of \StructType\CustomerEventField, "%s" given', is_object($arrayOfCustomerEventFieldCustomerEventFieldItem) ? get_class($arrayOfCustomerEventFieldCustomerEventFieldItem) : gettype($arrayOfCustomerEventFieldCustomerEventFieldItem)), __LINE__);
            }
        }
        if (is_null($customerEventField) || (is_array($customerEventField) && empty($customerEventField))) {
            unset($this->CustomerEventField);
        } else {
            $this->CustomerEventField = $customerEventField;
        }
        return $this;
    }
    /**
     * Add item to CustomerEventField value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerEventField $item
     * @return \ArrayType\ArrayOfCustomerEventField
     */
    public function addToCustomerEventField(\StructType\CustomerEventField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerEventField) {
            throw new \InvalidArgumentException(sprintf('The CustomerEventField property can only contain items of \StructType\CustomerEventField, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerEventField[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomerEventField|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomerEventField|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomerEventField|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomerEventField|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomerEventField|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerEventField
     */
    public function getAttributeName()
    {
        return 'CustomerEventField';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCustomerEventField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
