<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCountryResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfCountryResponse extends AbstractStructArrayBase
{
    /**
     * The CountryResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CountryResponse[]
     */
    public $CountryResponse;
    /**
     * Constructor method for ArrayOfCountryResponse
     * @uses ArrayOfCountryResponse::setCountryResponse()
     * @param \StructType\CountryResponse[] $countryResponse
     */
    public function __construct(array $countryResponse = array())
    {
        $this
            ->setCountryResponse($countryResponse);
    }
    /**
     * Get CountryResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CountryResponse[]|null
     */
    public function getCountryResponse()
    {
        return isset($this->CountryResponse) ? $this->CountryResponse : null;
    }
    /**
     * Set CountryResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CountryResponse[] $countryResponse
     * @return \ArrayType\ArrayOfCountryResponse
     */
    public function setCountryResponse(array $countryResponse = array())
    {
        foreach ($countryResponse as $arrayOfCountryResponseCountryResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfCountryResponseCountryResponseItem instanceof \StructType\CountryResponse) {
                throw new \InvalidArgumentException(sprintf('The CountryResponse property can only contain items of \StructType\CountryResponse, "%s" given', is_object($arrayOfCountryResponseCountryResponseItem) ? get_class($arrayOfCountryResponseCountryResponseItem) : gettype($arrayOfCountryResponseCountryResponseItem)), __LINE__);
            }
        }
        if (is_null($countryResponse) || (is_array($countryResponse) && empty($countryResponse))) {
            unset($this->CountryResponse);
        } else {
            $this->CountryResponse = $countryResponse;
        }
        return $this;
    }
    /**
     * Add item to CountryResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\CountryResponse $item
     * @return \ArrayType\ArrayOfCountryResponse
     */
    public function addToCountryResponse(\StructType\CountryResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CountryResponse) {
            throw new \InvalidArgumentException(sprintf('The CountryResponse property can only contain items of \StructType\CountryResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CountryResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CountryResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CountryResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CountryResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CountryResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CountryResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CountryResponse
     */
    public function getAttributeName()
    {
        return 'CountryResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCountryResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
