<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCompanyNewsResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfCompanyNewsResponse extends AbstractStructArrayBase
{
    /**
     * The CompanyNewsResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CompanyNewsResponse[]
     */
    public $CompanyNewsResponse;
    /**
     * Constructor method for ArrayOfCompanyNewsResponse
     * @uses ArrayOfCompanyNewsResponse::setCompanyNewsResponse()
     * @param \StructType\CompanyNewsResponse[] $companyNewsResponse
     */
    public function __construct(array $companyNewsResponse = array())
    {
        $this
            ->setCompanyNewsResponse($companyNewsResponse);
    }
    /**
     * Get CompanyNewsResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CompanyNewsResponse[]|null
     */
    public function getCompanyNewsResponse()
    {
        return isset($this->CompanyNewsResponse) ? $this->CompanyNewsResponse : null;
    }
    /**
     * Set CompanyNewsResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyNewsResponse[] $companyNewsResponse
     * @return \ArrayType\ArrayOfCompanyNewsResponse
     */
    public function setCompanyNewsResponse(array $companyNewsResponse = array())
    {
        foreach ($companyNewsResponse as $arrayOfCompanyNewsResponseCompanyNewsResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfCompanyNewsResponseCompanyNewsResponseItem instanceof \StructType\CompanyNewsResponse) {
                throw new \InvalidArgumentException(sprintf('The CompanyNewsResponse property can only contain items of \StructType\CompanyNewsResponse, "%s" given', is_object($arrayOfCompanyNewsResponseCompanyNewsResponseItem) ? get_class($arrayOfCompanyNewsResponseCompanyNewsResponseItem) : gettype($arrayOfCompanyNewsResponseCompanyNewsResponseItem)), __LINE__);
            }
        }
        if (is_null($companyNewsResponse) || (is_array($companyNewsResponse) && empty($companyNewsResponse))) {
            unset($this->CompanyNewsResponse);
        } else {
            $this->CompanyNewsResponse = $companyNewsResponse;
        }
        return $this;
    }
    /**
     * Add item to CompanyNewsResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyNewsResponse $item
     * @return \ArrayType\ArrayOfCompanyNewsResponse
     */
    public function addToCompanyNewsResponse(\StructType\CompanyNewsResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyNewsResponse) {
            throw new \InvalidArgumentException(sprintf('The CompanyNewsResponse property can only contain items of \StructType\CompanyNewsResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CompanyNewsResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CompanyNewsResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CompanyNewsResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CompanyNewsResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CompanyNewsResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CompanyNewsResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CompanyNewsResponse
     */
    public function getAttributeName()
    {
        return 'CompanyNewsResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCompanyNewsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
