<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateEntityRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:UpdateEntityRequest
 * @subpackage Structs
 */
class UpdateEntityRequest extends ApiRequest
{
    /**
     * The Entity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Entity
     */
    public $Entity;
    /**
     * The EntityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EntityName;
    /**
     * Constructor method for UpdateEntityRequest
     * @uses UpdateEntityRequest::setEntity()
     * @uses UpdateEntityRequest::setEntityName()
     * @param \StructType\Entity $entity
     * @param string $entityName
     */
    public function __construct(\StructType\Entity $entity = null, $entityName = null)
    {
        $this
            ->setEntity($entity)
            ->setEntityName($entityName);
    }
    /**
     * Get Entity value
     * @return \StructType\Entity|null
     */
    public function getEntity()
    {
        return $this->Entity;
    }
    /**
     * Set Entity value
     * @param \StructType\Entity $entity
     * @return \StructType\UpdateEntityRequest
     */
    public function setEntity(\StructType\Entity $entity = null)
    {
        $this->Entity = $entity;
        return $this;
    }
    /**
     * Get EntityName value
     * @return string|null
     */
    public function getEntityName()
    {
        return $this->EntityName;
    }
    /**
     * Set EntityName value
     * @param string $entityName
     * @return \StructType\UpdateEntityRequest
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entityName)), __LINE__);
        }
        $this->EntityName = $entityName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateEntityRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
