<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCalendarItemResponse StructType
 * @subpackage Structs
 */
class UpdateCalendarItemResponse extends ApiResponse
{
    /**
     * The CalendarID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CalendarID;
    /**
     * The CalendarItemID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CalendarItemID;
    /**
     * Constructor method for UpdateCalendarItemResponse
     * @uses UpdateCalendarItemResponse::setCalendarID()
     * @uses UpdateCalendarItemResponse::setCalendarItemID()
     * @param int $calendarID
     * @param int $calendarItemID
     */
    public function __construct($calendarID = null, $calendarItemID = null)
    {
        $this
            ->setCalendarID($calendarID)
            ->setCalendarItemID($calendarItemID);
    }
    /**
     * Get CalendarID value
     * @return int
     */
    public function getCalendarID()
    {
        return $this->CalendarID;
    }
    /**
     * Set CalendarID value
     * @param int $calendarID
     * @return \StructType\UpdateCalendarItemResponse
     */
    public function setCalendarID($calendarID = null)
    {
        // validation for constraint: int
        if (!is_null($calendarID) && !is_numeric($calendarID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($calendarID)), __LINE__);
        }
        $this->CalendarID = $calendarID;
        return $this;
    }
    /**
     * Get CalendarItemID value
     * @return int
     */
    public function getCalendarItemID()
    {
        return $this->CalendarItemID;
    }
    /**
     * Set CalendarItemID value
     * @param int $calendarItemID
     * @return \StructType\UpdateCalendarItemResponse
     */
    public function setCalendarItemID($calendarItemID = null)
    {
        // validation for constraint: int
        if (!is_null($calendarItemID) && !is_numeric($calendarItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($calendarItemID)), __LINE__);
        }
        $this->CalendarItemID = $calendarItemID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateCalendarItemResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
