<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetItemKitMembersRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:SetItemKitMembersRequest
 * @subpackage Structs
 */
class SetItemKitMembersRequest extends ApiRequest
{
    /**
     * The ParentItemCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ParentItemCode;
    /**
     * The ItemKitMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfKitMember
     */
    public $ItemKitMembers;
    /**
     * Constructor method for SetItemKitMembersRequest
     * @uses SetItemKitMembersRequest::setParentItemCode()
     * @uses SetItemKitMembersRequest::setItemKitMembers()
     * @param string $parentItemCode
     * @param \ArrayType\ArrayOfKitMember $itemKitMembers
     */
    public function __construct($parentItemCode = null, \ArrayType\ArrayOfKitMember $itemKitMembers = null)
    {
        $this
            ->setParentItemCode($parentItemCode)
            ->setItemKitMembers($itemKitMembers);
    }
    /**
     * Get ParentItemCode value
     * @return string|null
     */
    public function getParentItemCode()
    {
        return $this->ParentItemCode;
    }
    /**
     * Set ParentItemCode value
     * @param string $parentItemCode
     * @return \StructType\SetItemKitMembersRequest
     */
    public function setParentItemCode($parentItemCode = null)
    {
        // validation for constraint: string
        if (!is_null($parentItemCode) && !is_string($parentItemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parentItemCode)), __LINE__);
        }
        $this->ParentItemCode = $parentItemCode;
        return $this;
    }
    /**
     * Get ItemKitMembers value
     * @return \ArrayType\ArrayOfKitMember|null
     */
    public function getItemKitMembers()
    {
        return $this->ItemKitMembers;
    }
    /**
     * Set ItemKitMembers value
     * @param \ArrayType\ArrayOfKitMember $itemKitMembers
     * @return \StructType\SetItemKitMembersRequest
     */
    public function setItemKitMembers(\ArrayType\ArrayOfKitMember $itemKitMembers = null)
    {
        $this->ItemKitMembers = $itemKitMembers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetItemKitMembersRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
