<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetCustomerLeadSocialNetworksRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:SetCustomerLeadSocialNetworksRequest
 * @subpackage Structs
 */
class SetCustomerLeadSocialNetworksRequest extends ApiRequest
{
    /**
     * The CustomerLeadID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerLeadID;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The CustomerLeadSocialNetworks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCustomerLeadSocialNetworkRequest
     */
    public $CustomerLeadSocialNetworks;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for SetCustomerLeadSocialNetworksRequest
     * @uses SetCustomerLeadSocialNetworksRequest::setCustomerLeadID()
     * @uses SetCustomerLeadSocialNetworksRequest::setCustomerID()
     * @uses SetCustomerLeadSocialNetworksRequest::setCustomerLeadSocialNetworks()
     * @uses SetCustomerLeadSocialNetworksRequest::setCustomerKey()
     * @param int $customerLeadID
     * @param int $customerID
     * @param \ArrayType\ArrayOfCustomerLeadSocialNetworkRequest $customerLeadSocialNetworks
     * @param string $customerKey
     */
    public function __construct($customerLeadID = null, $customerID = null, \ArrayType\ArrayOfCustomerLeadSocialNetworkRequest $customerLeadSocialNetworks = null, $customerKey = null)
    {
        $this
            ->setCustomerLeadID($customerLeadID)
            ->setCustomerID($customerID)
            ->setCustomerLeadSocialNetworks($customerLeadSocialNetworks)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerLeadID value
     * @return int
     */
    public function getCustomerLeadID()
    {
        return $this->CustomerLeadID;
    }
    /**
     * Set CustomerLeadID value
     * @param int $customerLeadID
     * @return \StructType\SetCustomerLeadSocialNetworksRequest
     */
    public function setCustomerLeadID($customerLeadID = null)
    {
        // validation for constraint: int
        if (!is_null($customerLeadID) && !is_numeric($customerLeadID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerLeadID)), __LINE__);
        }
        $this->CustomerLeadID = $customerLeadID;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\SetCustomerLeadSocialNetworksRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get CustomerLeadSocialNetworks value
     * @return \ArrayType\ArrayOfCustomerLeadSocialNetworkRequest|null
     */
    public function getCustomerLeadSocialNetworks()
    {
        return $this->CustomerLeadSocialNetworks;
    }
    /**
     * Set CustomerLeadSocialNetworks value
     * @param \ArrayType\ArrayOfCustomerLeadSocialNetworkRequest $customerLeadSocialNetworks
     * @return \StructType\SetCustomerLeadSocialNetworksRequest
     */
    public function setCustomerLeadSocialNetworks(\ArrayType\ArrayOfCustomerLeadSocialNetworkRequest $customerLeadSocialNetworks = null)
    {
        $this->CustomerLeadSocialNetworks = $customerLeadSocialNetworks;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\SetCustomerLeadSocialNetworksRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetCustomerLeadSocialNetworksRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
