<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetBinaryPreferenceRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:SetBinaryPreferenceRequest
 * @subpackage Structs
 */
class SetBinaryPreferenceRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The PlacementType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PlacementType;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for SetBinaryPreferenceRequest
     * @uses SetBinaryPreferenceRequest::setCustomerID()
     * @uses SetBinaryPreferenceRequest::setPlacementType()
     * @uses SetBinaryPreferenceRequest::setCustomerKey()
     * @param int $customerID
     * @param string $placementType
     * @param string $customerKey
     */
    public function __construct($customerID = null, $placementType = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setPlacementType($placementType)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\SetBinaryPreferenceRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get PlacementType value
     * @return string
     */
    public function getPlacementType()
    {
        return $this->PlacementType;
    }
    /**
     * Set PlacementType value
     * @uses \EnumType\BinaryPlacementType::valueIsValid()
     * @uses \EnumType\BinaryPlacementType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $placementType
     * @return \StructType\SetBinaryPreferenceRequest
     */
    public function setPlacementType($placementType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BinaryPlacementType::valueIsValid($placementType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $placementType, implode(', ', \EnumType\BinaryPlacementType::getValidValues())), __LINE__);
        }
        $this->PlacementType = $placementType;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\SetBinaryPreferenceRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetBinaryPreferenceRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
