<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetAccountDirectDepositRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:SetAccountDirectDepositRequest
 * @subpackage Structs
 */
class SetAccountDirectDepositRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The DepositAccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DepositAccountType;
    /**
     * The BankAccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BankAccountType;
    /**
     * The NameOnAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NameOnAccount;
    /**
     * The BankAccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankAccountNumber;
    /**
     * The BankRoutingNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankRoutingNumber;
    /**
     * The BankName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankName;
    /**
     * The BankAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankAddress;
    /**
     * The BankCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankCity;
    /**
     * The BankState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankState;
    /**
     * The BankZip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankZip;
    /**
     * The BankCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankCountry;
    /**
     * The Iban
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Iban;
    /**
     * The SwiftCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SwiftCode;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for SetAccountDirectDepositRequest
     * @uses SetAccountDirectDepositRequest::setCustomerID()
     * @uses SetAccountDirectDepositRequest::setDepositAccountType()
     * @uses SetAccountDirectDepositRequest::setBankAccountType()
     * @uses SetAccountDirectDepositRequest::setNameOnAccount()
     * @uses SetAccountDirectDepositRequest::setBankAccountNumber()
     * @uses SetAccountDirectDepositRequest::setBankRoutingNumber()
     * @uses SetAccountDirectDepositRequest::setBankName()
     * @uses SetAccountDirectDepositRequest::setBankAddress()
     * @uses SetAccountDirectDepositRequest::setBankCity()
     * @uses SetAccountDirectDepositRequest::setBankState()
     * @uses SetAccountDirectDepositRequest::setBankZip()
     * @uses SetAccountDirectDepositRequest::setBankCountry()
     * @uses SetAccountDirectDepositRequest::setIban()
     * @uses SetAccountDirectDepositRequest::setSwiftCode()
     * @uses SetAccountDirectDepositRequest::setCustomerKey()
     * @param int $customerID
     * @param string $depositAccountType
     * @param string $bankAccountType
     * @param string $nameOnAccount
     * @param string $bankAccountNumber
     * @param string $bankRoutingNumber
     * @param string $bankName
     * @param string $bankAddress
     * @param string $bankCity
     * @param string $bankState
     * @param string $bankZip
     * @param string $bankCountry
     * @param string $iban
     * @param string $swiftCode
     * @param string $customerKey
     */
    public function __construct($customerID = null, $depositAccountType = null, $bankAccountType = null, $nameOnAccount = null, $bankAccountNumber = null, $bankRoutingNumber = null, $bankName = null, $bankAddress = null, $bankCity = null, $bankState = null, $bankZip = null, $bankCountry = null, $iban = null, $swiftCode = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setDepositAccountType($depositAccountType)
            ->setBankAccountType($bankAccountType)
            ->setNameOnAccount($nameOnAccount)
            ->setBankAccountNumber($bankAccountNumber)
            ->setBankRoutingNumber($bankRoutingNumber)
            ->setBankName($bankName)
            ->setBankAddress($bankAddress)
            ->setBankCity($bankCity)
            ->setBankState($bankState)
            ->setBankZip($bankZip)
            ->setBankCountry($bankCountry)
            ->setIban($iban)
            ->setSwiftCode($swiftCode)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\SetAccountDirectDepositRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get DepositAccountType value
     * @return string
     */
    public function getDepositAccountType()
    {
        return $this->DepositAccountType;
    }
    /**
     * Set DepositAccountType value
     * @uses \EnumType\DepositAccountType::valueIsValid()
     * @uses \EnumType\DepositAccountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $depositAccountType
     * @return \StructType\SetAccountDirectDepositRequest
     */
    public function setDepositAccountType($depositAccountType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DepositAccountType::valueIsValid($depositAccountType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $depositAccountType, implode(', ', \EnumType\DepositAccountType::getValidValues())), __LINE__);
        }
        $this->DepositAccountType = $depositAccountType;
        return $this;
    }
    /**
     * Get BankAccountType value
     * @return string
     */
    public function getBankAccountType()
    {
        return $this->BankAccountType;
    }
    /**
     * Set BankAccountType value
     * @uses \EnumType\BankAccountType::valueIsValid()
     * @uses \EnumType\BankAccountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bankAccountType
     * @return \StructType\SetAccountDirectDepositRequest
     */
    public function setBankAccountType($bankAccountType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BankAccountType::valueIsValid($bankAccountType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $bankAccountType, implode(', ', \EnumType\BankAccountType::getValidValues())), __LINE__);
        }
        $this->BankAccountType = $bankAccountType;
        return $this;
    }
    /**
     * Get NameOnAccount value
     * @return string|null
     */
    public function getNameOnAccount()
    {
        return $this->NameOnAccount;
    }
    /**
     * Set NameOnAccount value
     * @param string $nameOnAccount
     * @return \StructType\SetAccountDirectDepositRequest
     */
    public function setNameOnAccount($nameOnAccount = null)
    {
        // validation for constraint: string
        if (!is_null($nameOnAccount) && !is_string($nameOnAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameOnAccount)), __LINE__);
        }
        $this->NameOnAccount = $nameOnAccount;
        return $this;
    }
    /**
     * Get BankAccountNumber value
     * @return string|null
     */
    public function getBankAccountNumber()
    {
        return $this->BankAccountNumber;
    }
    /**
     * Set BankAccountNumber value
     * @param string $bankAccountNumber
     * @return \StructType\SetAccountDirectDepositRequest
     */
    public function setBankAccountNumber($bankAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountNumber) && !is_string($bankAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankAccountNumber)), __LINE__);
        }
        $this->BankAccountNumber = $bankAccountNumber;
        return $this;
    }
    /**
     * Get BankRoutingNumber value
     * @return string|null
     */
    public function getBankRoutingNumber()
    {
        return $this->BankRoutingNumber;
    }
    /**
     * Set BankRoutingNumber value
     * @param string $bankRoutingNumber
     * @return \StructType\SetAccountDirectDepositRequest
     */
    public function setBankRoutingNumber($bankRoutingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankRoutingNumber) && !is_string($bankRoutingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankRoutingNumber)), __LINE__);
        }
        $this->BankRoutingNumber = $bankRoutingNumber;
        return $this;
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->BankName;
    }
    /**
     * Set BankName value
     * @param string $bankName
     * @return \StructType\SetAccountDirectDepositRequest
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankName)), __LINE__);
        }
        $this->BankName = $bankName;
        return $this;
    }
    /**
     * Get BankAddress value
     * @return string|null
     */
    public function getBankAddress()
    {
        return $this->BankAddress;
    }
    /**
     * Set BankAddress value
     * @param string $bankAddress
     * @return \StructType\SetAccountDirectDepositRequest
     */
    public function setBankAddress($bankAddress = null)
    {
        // validation for constraint: string
        if (!is_null($bankAddress) && !is_string($bankAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankAddress)), __LINE__);
        }
        $this->BankAddress = $bankAddress;
        return $this;
    }
    /**
     * Get BankCity value
     * @return string|null
     */
    public function getBankCity()
    {
        return $this->BankCity;
    }
    /**
     * Set BankCity value
     * @param string $bankCity
     * @return \StructType\SetAccountDirectDepositRequest
     */
    public function setBankCity($bankCity = null)
    {
        // validation for constraint: string
        if (!is_null($bankCity) && !is_string($bankCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankCity)), __LINE__);
        }
        $this->BankCity = $bankCity;
        return $this;
    }
    /**
     * Get BankState value
     * @return string|null
     */
    public function getBankState()
    {
        return $this->BankState;
    }
    /**
     * Set BankState value
     * @param string $bankState
     * @return \StructType\SetAccountDirectDepositRequest
     */
    public function setBankState($bankState = null)
    {
        // validation for constraint: string
        if (!is_null($bankState) && !is_string($bankState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankState)), __LINE__);
        }
        $this->BankState = $bankState;
        return $this;
    }
    /**
     * Get BankZip value
     * @return string|null
     */
    public function getBankZip()
    {
        return $this->BankZip;
    }
    /**
     * Set BankZip value
     * @param string $bankZip
     * @return \StructType\SetAccountDirectDepositRequest
     */
    public function setBankZip($bankZip = null)
    {
        // validation for constraint: string
        if (!is_null($bankZip) && !is_string($bankZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankZip)), __LINE__);
        }
        $this->BankZip = $bankZip;
        return $this;
    }
    /**
     * Get BankCountry value
     * @return string|null
     */
    public function getBankCountry()
    {
        return $this->BankCountry;
    }
    /**
     * Set BankCountry value
     * @param string $bankCountry
     * @return \StructType\SetAccountDirectDepositRequest
     */
    public function setBankCountry($bankCountry = null)
    {
        // validation for constraint: string
        if (!is_null($bankCountry) && !is_string($bankCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankCountry)), __LINE__);
        }
        $this->BankCountry = $bankCountry;
        return $this;
    }
    /**
     * Get Iban value
     * @return string|null
     */
    public function getIban()
    {
        return $this->Iban;
    }
    /**
     * Set Iban value
     * @param string $iban
     * @return \StructType\SetAccountDirectDepositRequest
     */
    public function setIban($iban = null)
    {
        // validation for constraint: string
        if (!is_null($iban) && !is_string($iban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iban)), __LINE__);
        }
        $this->Iban = $iban;
        return $this;
    }
    /**
     * Get SwiftCode value
     * @return string|null
     */
    public function getSwiftCode()
    {
        return $this->SwiftCode;
    }
    /**
     * Set SwiftCode value
     * @param string $swiftCode
     * @return \StructType\SetAccountDirectDepositRequest
     */
    public function setSwiftCode($swiftCode = null)
    {
        // validation for constraint: string
        if (!is_null($swiftCode) && !is_string($swiftCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($swiftCode)), __LINE__);
        }
        $this->SwiftCode = $swiftCode;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\SetAccountDirectDepositRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetAccountDirectDepositRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
