<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendEmailRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:SendEmailRequest
 * @subpackage Structs
 */
class SendEmailRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CustomerID;
    /**
     * The MailFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailFrom;
    /**
     * The MailTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailTo;
    /**
     * The Subject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Subject;
    /**
     * The Body
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Body;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for SendEmailRequest
     * @uses SendEmailRequest::setCustomerID()
     * @uses SendEmailRequest::setMailFrom()
     * @uses SendEmailRequest::setMailTo()
     * @uses SendEmailRequest::setSubject()
     * @uses SendEmailRequest::setBody()
     * @uses SendEmailRequest::setCustomerKey()
     * @param int $customerID
     * @param string $mailFrom
     * @param string $mailTo
     * @param string $subject
     * @param string $body
     * @param string $customerKey
     */
    public function __construct($customerID = null, $mailFrom = null, $mailTo = null, $subject = null, $body = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setMailFrom($mailFrom)
            ->setMailTo($mailTo)
            ->setSubject($subject)
            ->setBody($body)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\SendEmailRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get MailFrom value
     * @return string|null
     */
    public function getMailFrom()
    {
        return $this->MailFrom;
    }
    /**
     * Set MailFrom value
     * @param string $mailFrom
     * @return \StructType\SendEmailRequest
     */
    public function setMailFrom($mailFrom = null)
    {
        // validation for constraint: string
        if (!is_null($mailFrom) && !is_string($mailFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailFrom)), __LINE__);
        }
        $this->MailFrom = $mailFrom;
        return $this;
    }
    /**
     * Get MailTo value
     * @return string|null
     */
    public function getMailTo()
    {
        return $this->MailTo;
    }
    /**
     * Set MailTo value
     * @param string $mailTo
     * @return \StructType\SendEmailRequest
     */
    public function setMailTo($mailTo = null)
    {
        // validation for constraint: string
        if (!is_null($mailTo) && !is_string($mailTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailTo)), __LINE__);
        }
        $this->MailTo = $mailTo;
        return $this;
    }
    /**
     * Get Subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \StructType\SendEmailRequest
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subject)), __LINE__);
        }
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get Body value
     * @return string|null
     */
    public function getBody()
    {
        return $this->Body;
    }
    /**
     * Set Body value
     * @param string $body
     * @return \StructType\SendEmailRequest
     */
    public function setBody($body = null)
    {
        // validation for constraint: string
        if (!is_null($body) && !is_string($body)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($body)), __LINE__);
        }
        $this->Body = $body;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\SendEmailRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendEmailRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
