<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlaceEnrollerNodeRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:PlaceEnrollerNodeRequest
 * @subpackage Structs
 */
class PlaceEnrollerNodeRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The ToEnrollerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ToEnrollerID;
    /**
     * The Reason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reason;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * The ToEnrollerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ToEnrollerKey;
    /**
     * Constructor method for PlaceEnrollerNodeRequest
     * @uses PlaceEnrollerNodeRequest::setCustomerID()
     * @uses PlaceEnrollerNodeRequest::setToEnrollerID()
     * @uses PlaceEnrollerNodeRequest::setReason()
     * @uses PlaceEnrollerNodeRequest::setCustomerKey()
     * @uses PlaceEnrollerNodeRequest::setToEnrollerKey()
     * @param int $customerID
     * @param int $toEnrollerID
     * @param string $reason
     * @param string $customerKey
     * @param string $toEnrollerKey
     */
    public function __construct($customerID = null, $toEnrollerID = null, $reason = null, $customerKey = null, $toEnrollerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setToEnrollerID($toEnrollerID)
            ->setReason($reason)
            ->setCustomerKey($customerKey)
            ->setToEnrollerKey($toEnrollerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\PlaceEnrollerNodeRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get ToEnrollerID value
     * @return int
     */
    public function getToEnrollerID()
    {
        return $this->ToEnrollerID;
    }
    /**
     * Set ToEnrollerID value
     * @param int $toEnrollerID
     * @return \StructType\PlaceEnrollerNodeRequest
     */
    public function setToEnrollerID($toEnrollerID = null)
    {
        // validation for constraint: int
        if (!is_null($toEnrollerID) && !is_numeric($toEnrollerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($toEnrollerID)), __LINE__);
        }
        $this->ToEnrollerID = $toEnrollerID;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \StructType\PlaceEnrollerNodeRequest
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reason)), __LINE__);
        }
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\PlaceEnrollerNodeRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Get ToEnrollerKey value
     * @return string|null
     */
    public function getToEnrollerKey()
    {
        return $this->ToEnrollerKey;
    }
    /**
     * Set ToEnrollerKey value
     * @param string $toEnrollerKey
     * @return \StructType\PlaceEnrollerNodeRequest
     */
    public function setToEnrollerKey($toEnrollerKey = null)
    {
        // validation for constraint: string
        if (!is_null($toEnrollerKey) && !is_string($toEnrollerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toEnrollerKey)), __LINE__);
        }
        $this->ToEnrollerKey = $toEnrollerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlaceEnrollerNodeRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
