<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemMemberResponse StructType
 * @subpackage Structs
 */
class ItemMemberResponse extends AbstractStructBase
{
    /**
     * The InventoryStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InventoryStatus;
    /**
     * The StockLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StockLevel;
    /**
     * The AvailableStockLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AvailableStockLevel;
    /**
     * The ItemCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemCode;
    /**
     * The MemberDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MemberDescription;
    /**
     * The ItemDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemDescription;
    /**
     * Constructor method for ItemMemberResponse
     * @uses ItemMemberResponse::setInventoryStatus()
     * @uses ItemMemberResponse::setStockLevel()
     * @uses ItemMemberResponse::setAvailableStockLevel()
     * @uses ItemMemberResponse::setItemCode()
     * @uses ItemMemberResponse::setMemberDescription()
     * @uses ItemMemberResponse::setItemDescription()
     * @param string $inventoryStatus
     * @param int $stockLevel
     * @param int $availableStockLevel
     * @param string $itemCode
     * @param string $memberDescription
     * @param string $itemDescription
     */
    public function __construct($inventoryStatus = null, $stockLevel = null, $availableStockLevel = null, $itemCode = null, $memberDescription = null, $itemDescription = null)
    {
        $this
            ->setInventoryStatus($inventoryStatus)
            ->setStockLevel($stockLevel)
            ->setAvailableStockLevel($availableStockLevel)
            ->setItemCode($itemCode)
            ->setMemberDescription($memberDescription)
            ->setItemDescription($itemDescription);
    }
    /**
     * Get InventoryStatus value
     * @return string
     */
    public function getInventoryStatus()
    {
        return $this->InventoryStatus;
    }
    /**
     * Set InventoryStatus value
     * @uses \EnumType\InventoryStatusType::valueIsValid()
     * @uses \EnumType\InventoryStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $inventoryStatus
     * @return \StructType\ItemMemberResponse
     */
    public function setInventoryStatus($inventoryStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InventoryStatusType::valueIsValid($inventoryStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $inventoryStatus, implode(', ', \EnumType\InventoryStatusType::getValidValues())), __LINE__);
        }
        $this->InventoryStatus = $inventoryStatus;
        return $this;
    }
    /**
     * Get StockLevel value
     * @return int
     */
    public function getStockLevel()
    {
        return $this->StockLevel;
    }
    /**
     * Set StockLevel value
     * @param int $stockLevel
     * @return \StructType\ItemMemberResponse
     */
    public function setStockLevel($stockLevel = null)
    {
        // validation for constraint: int
        if (!is_null($stockLevel) && !is_numeric($stockLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($stockLevel)), __LINE__);
        }
        $this->StockLevel = $stockLevel;
        return $this;
    }
    /**
     * Get AvailableStockLevel value
     * @return int
     */
    public function getAvailableStockLevel()
    {
        return $this->AvailableStockLevel;
    }
    /**
     * Set AvailableStockLevel value
     * @param int $availableStockLevel
     * @return \StructType\ItemMemberResponse
     */
    public function setAvailableStockLevel($availableStockLevel = null)
    {
        // validation for constraint: int
        if (!is_null($availableStockLevel) && !is_numeric($availableStockLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($availableStockLevel)), __LINE__);
        }
        $this->AvailableStockLevel = $availableStockLevel;
        return $this;
    }
    /**
     * Get ItemCode value
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }
    /**
     * Set ItemCode value
     * @param string $itemCode
     * @return \StructType\ItemMemberResponse
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemCode)), __LINE__);
        }
        $this->ItemCode = $itemCode;
        return $this;
    }
    /**
     * Get MemberDescription value
     * @return string|null
     */
    public function getMemberDescription()
    {
        return $this->MemberDescription;
    }
    /**
     * Set MemberDescription value
     * @param string $memberDescription
     * @return \StructType\ItemMemberResponse
     */
    public function setMemberDescription($memberDescription = null)
    {
        // validation for constraint: string
        if (!is_null($memberDescription) && !is_string($memberDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($memberDescription)), __LINE__);
        }
        $this->MemberDescription = $memberDescription;
        return $this;
    }
    /**
     * Get ItemDescription value
     * @return string|null
     */
    public function getItemDescription()
    {
        return $this->ItemDescription;
    }
    /**
     * Set ItemDescription value
     * @param string $itemDescription
     * @return \StructType\ItemMemberResponse
     */
    public function setItemDescription($itemDescription = null)
    {
        // validation for constraint: string
        if (!is_null($itemDescription) && !is_string($itemDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemDescription)), __LINE__);
        }
        $this->ItemDescription = $itemDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemMemberResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
