<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IsUniLevelChildValidateRequest StructType
 * @subpackage Structs
 */
class IsUniLevelChildValidateRequest extends ValidateRequest
{
    /**
     * The ParentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ParentID;
    /**
     * The ChildID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChildID;
    /**
     * The ParentKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ParentKey;
    /**
     * The ChildKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChildKey;
    /**
     * Constructor method for IsUniLevelChildValidateRequest
     * @uses IsUniLevelChildValidateRequest::setParentID()
     * @uses IsUniLevelChildValidateRequest::setChildID()
     * @uses IsUniLevelChildValidateRequest::setParentKey()
     * @uses IsUniLevelChildValidateRequest::setChildKey()
     * @param int $parentID
     * @param int $childID
     * @param string $parentKey
     * @param string $childKey
     */
    public function __construct($parentID = null, $childID = null, $parentKey = null, $childKey = null)
    {
        $this
            ->setParentID($parentID)
            ->setChildID($childID)
            ->setParentKey($parentKey)
            ->setChildKey($childKey);
    }
    /**
     * Get ParentID value
     * @return int
     */
    public function getParentID()
    {
        return $this->ParentID;
    }
    /**
     * Set ParentID value
     * @param int $parentID
     * @return \StructType\IsUniLevelChildValidateRequest
     */
    public function setParentID($parentID = null)
    {
        // validation for constraint: int
        if (!is_null($parentID) && !is_numeric($parentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($parentID)), __LINE__);
        }
        $this->ParentID = $parentID;
        return $this;
    }
    /**
     * Get ChildID value
     * @return int
     */
    public function getChildID()
    {
        return $this->ChildID;
    }
    /**
     * Set ChildID value
     * @param int $childID
     * @return \StructType\IsUniLevelChildValidateRequest
     */
    public function setChildID($childID = null)
    {
        // validation for constraint: int
        if (!is_null($childID) && !is_numeric($childID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($childID)), __LINE__);
        }
        $this->ChildID = $childID;
        return $this;
    }
    /**
     * Get ParentKey value
     * @return string|null
     */
    public function getParentKey()
    {
        return $this->ParentKey;
    }
    /**
     * Set ParentKey value
     * @param string $parentKey
     * @return \StructType\IsUniLevelChildValidateRequest
     */
    public function setParentKey($parentKey = null)
    {
        // validation for constraint: string
        if (!is_null($parentKey) && !is_string($parentKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parentKey)), __LINE__);
        }
        $this->ParentKey = $parentKey;
        return $this;
    }
    /**
     * Get ChildKey value
     * @return string|null
     */
    public function getChildKey()
    {
        return $this->ChildKey;
    }
    /**
     * Set ChildKey value
     * @param string $childKey
     * @return \StructType\IsUniLevelChildValidateRequest
     */
    public function setChildKey($childKey = null)
    {
        // validation for constraint: string
        if (!is_null($childKey) && !is_string($childKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($childKey)), __LINE__);
        }
        $this->ChildKey = $childKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IsUniLevelChildValidateRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
