<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetShoppingCartResponse StructType
 * @subpackage Structs
 */
class GetShoppingCartResponse extends ApiResponse
{
    /**
     * The ExistingOrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExistingOrderID;
    /**
     * The ExistingAutoOrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExistingAutoOrderID;
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOrderDetailResponse
     */
    public $Details;
    /**
     * Constructor method for GetShoppingCartResponse
     * @uses GetShoppingCartResponse::setExistingOrderID()
     * @uses GetShoppingCartResponse::setExistingAutoOrderID()
     * @uses GetShoppingCartResponse::setDetails()
     * @param int $existingOrderID
     * @param int $existingAutoOrderID
     * @param \ArrayType\ArrayOfOrderDetailResponse $details
     */
    public function __construct($existingOrderID = null, $existingAutoOrderID = null, \ArrayType\ArrayOfOrderDetailResponse $details = null)
    {
        $this
            ->setExistingOrderID($existingOrderID)
            ->setExistingAutoOrderID($existingAutoOrderID)
            ->setDetails($details);
    }
    /**
     * Get ExistingOrderID value
     * @return int
     */
    public function getExistingOrderID()
    {
        return $this->ExistingOrderID;
    }
    /**
     * Set ExistingOrderID value
     * @param int $existingOrderID
     * @return \StructType\GetShoppingCartResponse
     */
    public function setExistingOrderID($existingOrderID = null)
    {
        // validation for constraint: int
        if (!is_null($existingOrderID) && !is_numeric($existingOrderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($existingOrderID)), __LINE__);
        }
        $this->ExistingOrderID = $existingOrderID;
        return $this;
    }
    /**
     * Get ExistingAutoOrderID value
     * @return int
     */
    public function getExistingAutoOrderID()
    {
        return $this->ExistingAutoOrderID;
    }
    /**
     * Set ExistingAutoOrderID value
     * @param int $existingAutoOrderID
     * @return \StructType\GetShoppingCartResponse
     */
    public function setExistingAutoOrderID($existingAutoOrderID = null)
    {
        // validation for constraint: int
        if (!is_null($existingAutoOrderID) && !is_numeric($existingAutoOrderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($existingAutoOrderID)), __LINE__);
        }
        $this->ExistingAutoOrderID = $existingAutoOrderID;
        return $this;
    }
    /**
     * Get Details value
     * @return \ArrayType\ArrayOfOrderDetailResponse|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @param \ArrayType\ArrayOfOrderDetailResponse $details
     * @return \StructType\GetShoppingCartResponse
     */
    public function setDetails(\ArrayType\ArrayOfOrderDetailResponse $details = null)
    {
        $this->Details = $details;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetShoppingCartResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
