<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetShipMethodsRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetShipMethodsRequest
 * @subpackage Structs
 */
class GetShipMethodsRequest extends ApiRequest
{
    /**
     * The WarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WarehouseID;
    /**
     * The OrderSubTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $OrderSubTotal;
    /**
     * The OrderWieght
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $OrderWieght;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * Constructor method for GetShipMethodsRequest
     * @uses GetShipMethodsRequest::setWarehouseID()
     * @uses GetShipMethodsRequest::setOrderSubTotal()
     * @uses GetShipMethodsRequest::setOrderWieght()
     * @uses GetShipMethodsRequest::setCurrencyCode()
     * @param int $warehouseID
     * @param float $orderSubTotal
     * @param float $orderWieght
     * @param string $currencyCode
     */
    public function __construct($warehouseID = null, $orderSubTotal = null, $orderWieght = null, $currencyCode = null)
    {
        $this
            ->setWarehouseID($warehouseID)
            ->setOrderSubTotal($orderSubTotal)
            ->setOrderWieght($orderWieght)
            ->setCurrencyCode($currencyCode);
    }
    /**
     * Get WarehouseID value
     * @return int
     */
    public function getWarehouseID()
    {
        return $this->WarehouseID;
    }
    /**
     * Set WarehouseID value
     * @param int $warehouseID
     * @return \StructType\GetShipMethodsRequest
     */
    public function setWarehouseID($warehouseID = null)
    {
        // validation for constraint: int
        if (!is_null($warehouseID) && !is_numeric($warehouseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($warehouseID)), __LINE__);
        }
        $this->WarehouseID = $warehouseID;
        return $this;
    }
    /**
     * Get OrderSubTotal value
     * @return float
     */
    public function getOrderSubTotal()
    {
        return $this->OrderSubTotal;
    }
    /**
     * Set OrderSubTotal value
     * @param float $orderSubTotal
     * @return \StructType\GetShipMethodsRequest
     */
    public function setOrderSubTotal($orderSubTotal = null)
    {
        $this->OrderSubTotal = $orderSubTotal;
        return $this;
    }
    /**
     * Get OrderWieght value
     * @return float
     */
    public function getOrderWieght()
    {
        return $this->OrderWieght;
    }
    /**
     * Set OrderWieght value
     * @param float $orderWieght
     * @return \StructType\GetShipMethodsRequest
     */
    public function setOrderWieght($orderWieght = null)
    {
        $this->OrderWieght = $orderWieght;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\GetShipMethodsRequest
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetShipMethodsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
