<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSandboxResponse StructType
 * @subpackage Structs
 */
class GetSandboxResponse extends ApiResponse
{
    /**
     * The Sandbox
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Sandbox
     */
    public $Sandbox;
    /**
     * The Sandboxes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSandbox
     */
    public $Sandboxes;
    /**
     * Constructor method for GetSandboxResponse
     * @uses GetSandboxResponse::setSandbox()
     * @uses GetSandboxResponse::setSandboxes()
     * @param \StructType\Sandbox $sandbox
     * @param \ArrayType\ArrayOfSandbox $sandboxes
     */
    public function __construct(\StructType\Sandbox $sandbox = null, \ArrayType\ArrayOfSandbox $sandboxes = null)
    {
        $this
            ->setSandbox($sandbox)
            ->setSandboxes($sandboxes);
    }
    /**
     * Get Sandbox value
     * @return \StructType\Sandbox|null
     */
    public function getSandbox()
    {
        return $this->Sandbox;
    }
    /**
     * Set Sandbox value
     * @param \StructType\Sandbox $sandbox
     * @return \StructType\GetSandboxResponse
     */
    public function setSandbox(\StructType\Sandbox $sandbox = null)
    {
        $this->Sandbox = $sandbox;
        return $this;
    }
    /**
     * Get Sandboxes value
     * @return \ArrayType\ArrayOfSandbox|null
     */
    public function getSandboxes()
    {
        return $this->Sandboxes;
    }
    /**
     * Set Sandboxes value
     * @param \ArrayType\ArrayOfSandbox $sandboxes
     * @return \StructType\GetSandboxResponse
     */
    public function setSandboxes(\ArrayType\ArrayOfSandbox $sandboxes = null)
    {
        $this->Sandboxes = $sandboxes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetSandboxResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
