<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSandboxRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetSandboxRequest
 * @subpackage Structs
 */
class GetSandboxRequest extends ApiRequest
{
    /**
     * The SandboxID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SandboxID;
    /**
     * Constructor method for GetSandboxRequest
     * @uses GetSandboxRequest::setSandboxID()
     * @param int $sandboxID
     */
    public function __construct($sandboxID = null)
    {
        $this
            ->setSandboxID($sandboxID);
    }
    /**
     * Get SandboxID value
     * @return int
     */
    public function getSandboxID()
    {
        return $this->SandboxID;
    }
    /**
     * Set SandboxID value
     * @param int $sandboxID
     * @return \StructType\GetSandboxRequest
     */
    public function setSandboxID($sandboxID = null)
    {
        // validation for constraint: int
        if (!is_null($sandboxID) && !is_numeric($sandboxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sandboxID)), __LINE__);
        }
        $this->SandboxID = $sandboxID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetSandboxRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
