<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRankQualificationsResponse StructType
 * @subpackage Structs
 */
class GetRankQualificationsResponse extends ApiResponse
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The RankID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RankID;
    /**
     * The Qualifies
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Qualifies;
    /**
     * The QualifiesOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $QualifiesOverride;
    /**
     * The BackRankID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BackRankID;
    /**
     * The NextRankID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NextRankID;
    /**
     * The Score
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Score;
    /**
     * The RankDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RankDescription;
    /**
     * The PayeeQualificationLegs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfArrayOfQualificationResponse
     */
    public $PayeeQualificationLegs;
    /**
     * The BackRankDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BackRankDescription;
    /**
     * The NextRankDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NextRankDescription;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for GetRankQualificationsResponse
     * @uses GetRankQualificationsResponse::setCustomerID()
     * @uses GetRankQualificationsResponse::setRankID()
     * @uses GetRankQualificationsResponse::setQualifies()
     * @uses GetRankQualificationsResponse::setQualifiesOverride()
     * @uses GetRankQualificationsResponse::setBackRankID()
     * @uses GetRankQualificationsResponse::setNextRankID()
     * @uses GetRankQualificationsResponse::setScore()
     * @uses GetRankQualificationsResponse::setRankDescription()
     * @uses GetRankQualificationsResponse::setPayeeQualificationLegs()
     * @uses GetRankQualificationsResponse::setBackRankDescription()
     * @uses GetRankQualificationsResponse::setNextRankDescription()
     * @uses GetRankQualificationsResponse::setCustomerKey()
     * @param int $customerID
     * @param int $rankID
     * @param bool $qualifies
     * @param bool $qualifiesOverride
     * @param int $backRankID
     * @param int $nextRankID
     * @param float $score
     * @param string $rankDescription
     * @param \ArrayType\ArrayOfArrayOfQualificationResponse $payeeQualificationLegs
     * @param string $backRankDescription
     * @param string $nextRankDescription
     * @param string $customerKey
     */
    public function __construct($customerID = null, $rankID = null, $qualifies = null, $qualifiesOverride = null, $backRankID = null, $nextRankID = null, $score = null, $rankDescription = null, \ArrayType\ArrayOfArrayOfQualificationResponse $payeeQualificationLegs = null, $backRankDescription = null, $nextRankDescription = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setRankID($rankID)
            ->setQualifies($qualifies)
            ->setQualifiesOverride($qualifiesOverride)
            ->setBackRankID($backRankID)
            ->setNextRankID($nextRankID)
            ->setScore($score)
            ->setRankDescription($rankDescription)
            ->setPayeeQualificationLegs($payeeQualificationLegs)
            ->setBackRankDescription($backRankDescription)
            ->setNextRankDescription($nextRankDescription)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\GetRankQualificationsResponse
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get RankID value
     * @return int
     */
    public function getRankID()
    {
        return $this->RankID;
    }
    /**
     * Set RankID value
     * @param int $rankID
     * @return \StructType\GetRankQualificationsResponse
     */
    public function setRankID($rankID = null)
    {
        // validation for constraint: int
        if (!is_null($rankID) && !is_numeric($rankID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rankID)), __LINE__);
        }
        $this->RankID = $rankID;
        return $this;
    }
    /**
     * Get Qualifies value
     * @return bool
     */
    public function getQualifies()
    {
        return $this->Qualifies;
    }
    /**
     * Set Qualifies value
     * @param bool $qualifies
     * @return \StructType\GetRankQualificationsResponse
     */
    public function setQualifies($qualifies = null)
    {
        // validation for constraint: boolean
        if (!is_null($qualifies) && !is_bool($qualifies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($qualifies)), __LINE__);
        }
        $this->Qualifies = $qualifies;
        return $this;
    }
    /**
     * Get QualifiesOverride value
     * @return bool
     */
    public function getQualifiesOverride()
    {
        return $this->QualifiesOverride;
    }
    /**
     * Set QualifiesOverride value
     * @param bool $qualifiesOverride
     * @return \StructType\GetRankQualificationsResponse
     */
    public function setQualifiesOverride($qualifiesOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($qualifiesOverride) && !is_bool($qualifiesOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($qualifiesOverride)), __LINE__);
        }
        $this->QualifiesOverride = $qualifiesOverride;
        return $this;
    }
    /**
     * Get BackRankID value
     * @return int
     */
    public function getBackRankID()
    {
        return $this->BackRankID;
    }
    /**
     * Set BackRankID value
     * @param int $backRankID
     * @return \StructType\GetRankQualificationsResponse
     */
    public function setBackRankID($backRankID = null)
    {
        // validation for constraint: int
        if (!is_null($backRankID) && !is_numeric($backRankID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($backRankID)), __LINE__);
        }
        $this->BackRankID = $backRankID;
        return $this;
    }
    /**
     * Get NextRankID value
     * @return int
     */
    public function getNextRankID()
    {
        return $this->NextRankID;
    }
    /**
     * Set NextRankID value
     * @param int $nextRankID
     * @return \StructType\GetRankQualificationsResponse
     */
    public function setNextRankID($nextRankID = null)
    {
        // validation for constraint: int
        if (!is_null($nextRankID) && !is_numeric($nextRankID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nextRankID)), __LINE__);
        }
        $this->NextRankID = $nextRankID;
        return $this;
    }
    /**
     * Get Score value
     * @return float
     */
    public function getScore()
    {
        return $this->Score;
    }
    /**
     * Set Score value
     * @param float $score
     * @return \StructType\GetRankQualificationsResponse
     */
    public function setScore($score = null)
    {
        $this->Score = $score;
        return $this;
    }
    /**
     * Get RankDescription value
     * @return string|null
     */
    public function getRankDescription()
    {
        return $this->RankDescription;
    }
    /**
     * Set RankDescription value
     * @param string $rankDescription
     * @return \StructType\GetRankQualificationsResponse
     */
    public function setRankDescription($rankDescription = null)
    {
        // validation for constraint: string
        if (!is_null($rankDescription) && !is_string($rankDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rankDescription)), __LINE__);
        }
        $this->RankDescription = $rankDescription;
        return $this;
    }
    /**
     * Get PayeeQualificationLegs value
     * @return \ArrayType\ArrayOfArrayOfQualificationResponse|null
     */
    public function getPayeeQualificationLegs()
    {
        return $this->PayeeQualificationLegs;
    }
    /**
     * Set PayeeQualificationLegs value
     * @param \ArrayType\ArrayOfArrayOfQualificationResponse $payeeQualificationLegs
     * @return \StructType\GetRankQualificationsResponse
     */
    public function setPayeeQualificationLegs(\ArrayType\ArrayOfArrayOfQualificationResponse $payeeQualificationLegs = null)
    {
        $this->PayeeQualificationLegs = $payeeQualificationLegs;
        return $this;
    }
    /**
     * Get BackRankDescription value
     * @return string|null
     */
    public function getBackRankDescription()
    {
        return $this->BackRankDescription;
    }
    /**
     * Set BackRankDescription value
     * @param string $backRankDescription
     * @return \StructType\GetRankQualificationsResponse
     */
    public function setBackRankDescription($backRankDescription = null)
    {
        // validation for constraint: string
        if (!is_null($backRankDescription) && !is_string($backRankDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($backRankDescription)), __LINE__);
        }
        $this->BackRankDescription = $backRankDescription;
        return $this;
    }
    /**
     * Get NextRankDescription value
     * @return string|null
     */
    public function getNextRankDescription()
    {
        return $this->NextRankDescription;
    }
    /**
     * Set NextRankDescription value
     * @param string $nextRankDescription
     * @return \StructType\GetRankQualificationsResponse
     */
    public function setNextRankDescription($nextRankDescription = null)
    {
        // validation for constraint: string
        if (!is_null($nextRankDescription) && !is_string($nextRankDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nextRankDescription)), __LINE__);
        }
        $this->NextRankDescription = $nextRankDescription;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\GetRankQualificationsResponse
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetRankQualificationsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
