<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRandomMessageResponse StructType
 * @subpackage Structs
 */
class GetRandomMessageResponse extends ApiResponse
{
    /**
     * The RandomMessageID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RandomMessageID;
    /**
     * The Content
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Content;
    /**
     * Constructor method for GetRandomMessageResponse
     * @uses GetRandomMessageResponse::setRandomMessageID()
     * @uses GetRandomMessageResponse::setContent()
     * @param int $randomMessageID
     * @param string $content
     */
    public function __construct($randomMessageID = null, $content = null)
    {
        $this
            ->setRandomMessageID($randomMessageID)
            ->setContent($content);
    }
    /**
     * Get RandomMessageID value
     * @return int
     */
    public function getRandomMessageID()
    {
        return $this->RandomMessageID;
    }
    /**
     * Set RandomMessageID value
     * @param int $randomMessageID
     * @return \StructType\GetRandomMessageResponse
     */
    public function setRandomMessageID($randomMessageID = null)
    {
        // validation for constraint: int
        if (!is_null($randomMessageID) && !is_numeric($randomMessageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($randomMessageID)), __LINE__);
        }
        $this->RandomMessageID = $randomMessageID;
        return $this;
    }
    /**
     * Get Content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->Content;
    }
    /**
     * Set Content value
     * @param string $content
     * @return \StructType\GetRandomMessageResponse
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($content)), __LINE__);
        }
        $this->Content = $content;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetRandomMessageResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
