<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDownlineResponse StructType
 * @subpackage Structs
 */
class GetDownlineResponse extends ApiResponse
{
    /**
     * The RecordCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RecordCount;
    /**
     * The Nodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfNodeResponse
     */
    public $Nodes;
    /**
     * Constructor method for GetDownlineResponse
     * @uses GetDownlineResponse::setRecordCount()
     * @uses GetDownlineResponse::setNodes()
     * @param int $recordCount
     * @param \ArrayType\ArrayOfNodeResponse $nodes
     */
    public function __construct($recordCount = null, \ArrayType\ArrayOfNodeResponse $nodes = null)
    {
        $this
            ->setRecordCount($recordCount)
            ->setNodes($nodes);
    }
    /**
     * Get RecordCount value
     * @return int
     */
    public function getRecordCount()
    {
        return $this->RecordCount;
    }
    /**
     * Set RecordCount value
     * @param int $recordCount
     * @return \StructType\GetDownlineResponse
     */
    public function setRecordCount($recordCount = null)
    {
        // validation for constraint: int
        if (!is_null($recordCount) && !is_numeric($recordCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recordCount)), __LINE__);
        }
        $this->RecordCount = $recordCount;
        return $this;
    }
    /**
     * Get Nodes value
     * @return \ArrayType\ArrayOfNodeResponse|null
     */
    public function getNodes()
    {
        return $this->Nodes;
    }
    /**
     * Set Nodes value
     * @param \ArrayType\ArrayOfNodeResponse $nodes
     * @return \StructType\GetDownlineResponse
     */
    public function setNodes(\ArrayType\ArrayOfNodeResponse $nodes = null)
    {
        $this->Nodes = $nodes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDownlineResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
