<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomReportRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetCustomReportRequest
 * @subpackage Structs
 */
class GetCustomReportRequest extends ApiRequest
{
    /**
     * The ReportID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReportID;
    /**
     * The Parameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfParameterRequest
     */
    public $Parameters;
    /**
     * Constructor method for GetCustomReportRequest
     * @uses GetCustomReportRequest::setReportID()
     * @uses GetCustomReportRequest::setParameters()
     * @param int $reportID
     * @param \ArrayType\ArrayOfParameterRequest $parameters
     */
    public function __construct($reportID = null, \ArrayType\ArrayOfParameterRequest $parameters = null)
    {
        $this
            ->setReportID($reportID)
            ->setParameters($parameters);
    }
    /**
     * Get ReportID value
     * @return int
     */
    public function getReportID()
    {
        return $this->ReportID;
    }
    /**
     * Set ReportID value
     * @param int $reportID
     * @return \StructType\GetCustomReportRequest
     */
    public function setReportID($reportID = null)
    {
        // validation for constraint: int
        if (!is_null($reportID) && !is_numeric($reportID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reportID)), __LINE__);
        }
        $this->ReportID = $reportID;
        return $this;
    }
    /**
     * Get Parameters value
     * @return \ArrayType\ArrayOfParameterRequest|null
     */
    public function getParameters()
    {
        return $this->Parameters;
    }
    /**
     * Set Parameters value
     * @param \ArrayType\ArrayOfParameterRequest $parameters
     * @return \StructType\GetCustomReportRequest
     */
    public function setParameters(\ArrayType\ArrayOfParameterRequest $parameters = null)
    {
        $this->Parameters = $parameters;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCustomReportRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
