<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Entity StructType
 * @subpackage Structs
 */
class Entity extends AbstractStructBase
{
    /**
     * The SyncTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SyncTypeID;
    /**
     * The SchemaName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SchemaName;
    /**
     * The DbSchema
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DbSchema;
    /**
     * The EntityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EntityName;
    /**
     * The EntitySetName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EntitySetName;
    /**
     * The Properties
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProperty
     */
    public $Properties;
    /**
     * The Navigations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfNavigation
     */
    public $Navigations;
    /**
     * Constructor method for Entity
     * @uses Entity::setSyncTypeID()
     * @uses Entity::setSchemaName()
     * @uses Entity::setDbSchema()
     * @uses Entity::setEntityName()
     * @uses Entity::setEntitySetName()
     * @uses Entity::setProperties()
     * @uses Entity::setNavigations()
     * @param int $syncTypeID
     * @param string $schemaName
     * @param string $dbSchema
     * @param string $entityName
     * @param string $entitySetName
     * @param \ArrayType\ArrayOfProperty $properties
     * @param \ArrayType\ArrayOfNavigation $navigations
     */
    public function __construct($syncTypeID = null, $schemaName = null, $dbSchema = null, $entityName = null, $entitySetName = null, \ArrayType\ArrayOfProperty $properties = null, \ArrayType\ArrayOfNavigation $navigations = null)
    {
        $this
            ->setSyncTypeID($syncTypeID)
            ->setSchemaName($schemaName)
            ->setDbSchema($dbSchema)
            ->setEntityName($entityName)
            ->setEntitySetName($entitySetName)
            ->setProperties($properties)
            ->setNavigations($navigations);
    }
    /**
     * Get SyncTypeID value
     * @return int
     */
    public function getSyncTypeID()
    {
        return $this->SyncTypeID;
    }
    /**
     * Set SyncTypeID value
     * @param int $syncTypeID
     * @return \StructType\Entity
     */
    public function setSyncTypeID($syncTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($syncTypeID) && !is_numeric($syncTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($syncTypeID)), __LINE__);
        }
        $this->SyncTypeID = $syncTypeID;
        return $this;
    }
    /**
     * Get SchemaName value
     * @return string|null
     */
    public function getSchemaName()
    {
        return $this->SchemaName;
    }
    /**
     * Set SchemaName value
     * @param string $schemaName
     * @return \StructType\Entity
     */
    public function setSchemaName($schemaName = null)
    {
        // validation for constraint: string
        if (!is_null($schemaName) && !is_string($schemaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schemaName)), __LINE__);
        }
        $this->SchemaName = $schemaName;
        return $this;
    }
    /**
     * Get DbSchema value
     * @return string|null
     */
    public function getDbSchema()
    {
        return $this->DbSchema;
    }
    /**
     * Set DbSchema value
     * @param string $dbSchema
     * @return \StructType\Entity
     */
    public function setDbSchema($dbSchema = null)
    {
        // validation for constraint: string
        if (!is_null($dbSchema) && !is_string($dbSchema)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dbSchema)), __LINE__);
        }
        $this->DbSchema = $dbSchema;
        return $this;
    }
    /**
     * Get EntityName value
     * @return string|null
     */
    public function getEntityName()
    {
        return $this->EntityName;
    }
    /**
     * Set EntityName value
     * @param string $entityName
     * @return \StructType\Entity
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entityName)), __LINE__);
        }
        $this->EntityName = $entityName;
        return $this;
    }
    /**
     * Get EntitySetName value
     * @return string|null
     */
    public function getEntitySetName()
    {
        return $this->EntitySetName;
    }
    /**
     * Set EntitySetName value
     * @param string $entitySetName
     * @return \StructType\Entity
     */
    public function setEntitySetName($entitySetName = null)
    {
        // validation for constraint: string
        if (!is_null($entitySetName) && !is_string($entitySetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entitySetName)), __LINE__);
        }
        $this->EntitySetName = $entitySetName;
        return $this;
    }
    /**
     * Get Properties value
     * @return \ArrayType\ArrayOfProperty|null
     */
    public function getProperties()
    {
        return $this->Properties;
    }
    /**
     * Set Properties value
     * @param \ArrayType\ArrayOfProperty $properties
     * @return \StructType\Entity
     */
    public function setProperties(\ArrayType\ArrayOfProperty $properties = null)
    {
        $this->Properties = $properties;
        return $this;
    }
    /**
     * Get Navigations value
     * @return \ArrayType\ArrayOfNavigation|null
     */
    public function getNavigations()
    {
        return $this->Navigations;
    }
    /**
     * Set Navigations value
     * @param \ArrayType\ArrayOfNavigation $navigations
     * @return \StructType\Entity
     */
    public function setNavigations(\ArrayType\ArrayOfNavigation $navigations = null)
    {
        $this->Navigations = $navigations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Entity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
