<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmailAttachment StructType
 * @subpackage Structs
 */
class EmailAttachment extends AbstractStructBase
{
    /**
     * The ContentLength
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ContentLength;
    /**
     * The BinaryData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BinaryData;
    /**
     * The FileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileName;
    /**
     * Constructor method for EmailAttachment
     * @uses EmailAttachment::setContentLength()
     * @uses EmailAttachment::setBinaryData()
     * @uses EmailAttachment::setFileName()
     * @param int $contentLength
     * @param string $binaryData
     * @param string $fileName
     */
    public function __construct($contentLength = null, $binaryData = null, $fileName = null)
    {
        $this
            ->setContentLength($contentLength)
            ->setBinaryData($binaryData)
            ->setFileName($fileName);
    }
    /**
     * Get ContentLength value
     * @return int
     */
    public function getContentLength()
    {
        return $this->ContentLength;
    }
    /**
     * Set ContentLength value
     * @param int $contentLength
     * @return \StructType\EmailAttachment
     */
    public function setContentLength($contentLength = null)
    {
        // validation for constraint: int
        if (!is_null($contentLength) && !is_numeric($contentLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contentLength)), __LINE__);
        }
        $this->ContentLength = $contentLength;
        return $this;
    }
    /**
     * Get BinaryData value
     * @return string|null
     */
    public function getBinaryData()
    {
        return $this->BinaryData;
    }
    /**
     * Set BinaryData value
     * @param string $binaryData
     * @return \StructType\EmailAttachment
     */
    public function setBinaryData($binaryData = null)
    {
        // validation for constraint: string
        if (!is_null($binaryData) && !is_string($binaryData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($binaryData)), __LINE__);
        }
        $this->BinaryData = $binaryData;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\EmailAttachment
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EmailAttachment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
