<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteWebCategoryRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:DeleteWebCategoryRequest
 * @subpackage Structs
 */
class DeleteWebCategoryRequest extends ApiRequest
{
    /**
     * The WebID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WebID;
    /**
     * The CategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CategoryID;
    /**
     * Constructor method for DeleteWebCategoryRequest
     * @uses DeleteWebCategoryRequest::setWebID()
     * @uses DeleteWebCategoryRequest::setCategoryID()
     * @param int $webID
     * @param int $categoryID
     */
    public function __construct($webID = null, $categoryID = null)
    {
        $this
            ->setWebID($webID)
            ->setCategoryID($categoryID);
    }
    /**
     * Get WebID value
     * @return int
     */
    public function getWebID()
    {
        return $this->WebID;
    }
    /**
     * Set WebID value
     * @param int $webID
     * @return \StructType\DeleteWebCategoryRequest
     */
    public function setWebID($webID = null)
    {
        // validation for constraint: int
        if (!is_null($webID) && !is_numeric($webID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($webID)), __LINE__);
        }
        $this->WebID = $webID;
        return $this;
    }
    /**
     * Get CategoryID value
     * @return int
     */
    public function getCategoryID()
    {
        return $this->CategoryID;
    }
    /**
     * Set CategoryID value
     * @param int $categoryID
     * @return \StructType\DeleteWebCategoryRequest
     */
    public function setCategoryID($categoryID = null)
    {
        // validation for constraint: int
        if (!is_null($categoryID) && !is_numeric($categoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($categoryID)), __LINE__);
        }
        $this->CategoryID = $categoryID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteWebCategoryRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
