<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteMailFolderRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:DeleteMailFolderRequest
 * @subpackage Structs
 */
class DeleteMailFolderRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The MailFolderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MailFolderID;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for DeleteMailFolderRequest
     * @uses DeleteMailFolderRequest::setCustomerID()
     * @uses DeleteMailFolderRequest::setMailFolderID()
     * @uses DeleteMailFolderRequest::setCustomerKey()
     * @param int $customerID
     * @param int $mailFolderID
     * @param string $customerKey
     */
    public function __construct($customerID = null, $mailFolderID = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setMailFolderID($mailFolderID)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\DeleteMailFolderRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get MailFolderID value
     * @return int
     */
    public function getMailFolderID()
    {
        return $this->MailFolderID;
    }
    /**
     * Set MailFolderID value
     * @param int $mailFolderID
     * @return \StructType\DeleteMailFolderRequest
     */
    public function setMailFolderID($mailFolderID = null)
    {
        // validation for constraint: int
        if (!is_null($mailFolderID) && !is_numeric($mailFolderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($mailFolderID)), __LINE__);
        }
        $this->MailFolderID = $mailFolderID;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\DeleteMailFolderRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteMailFolderRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
