<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteCustomerLeadRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:DeleteCustomerLeadRequest
 * @subpackage Structs
 */
class DeleteCustomerLeadRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The CustomerLeadID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerLeadID;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for DeleteCustomerLeadRequest
     * @uses DeleteCustomerLeadRequest::setCustomerID()
     * @uses DeleteCustomerLeadRequest::setCustomerLeadID()
     * @uses DeleteCustomerLeadRequest::setCustomerKey()
     * @param int $customerID
     * @param int $customerLeadID
     * @param string $customerKey
     */
    public function __construct($customerID = null, $customerLeadID = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setCustomerLeadID($customerLeadID)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\DeleteCustomerLeadRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get CustomerLeadID value
     * @return int
     */
    public function getCustomerLeadID()
    {
        return $this->CustomerLeadID;
    }
    /**
     * Set CustomerLeadID value
     * @param int $customerLeadID
     * @return \StructType\DeleteCustomerLeadRequest
     */
    public function setCustomerLeadID($customerLeadID = null)
    {
        // validation for constraint: int
        if (!is_null($customerLeadID) && !is_numeric($customerLeadID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerLeadID)), __LINE__);
        }
        $this->CustomerLeadID = $customerLeadID;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\DeleteCustomerLeadRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteCustomerLeadRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
