<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DebitBankAccountRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:DebitBankAccountRequest
 * @subpackage Structs
 */
class DebitBankAccountRequest extends BaseDebitBankAccountRequest
{
    /**
     * The BankAccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BankAccountType;
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderID;
    /**
     * The MaxAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxAmount;
    /**
     * The BankAccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankAccountNumber;
    /**
     * The BankRoutingNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankRoutingNumber;
    /**
     * The BankName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankName;
    /**
     * The CheckNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CheckNumber;
    /**
     * The NameOnAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NameOnAccount;
    /**
     * The BillingAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingAddress;
    /**
     * The BillingAddress2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingAddress2;
    /**
     * The BillingCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingCity;
    /**
     * The BillingState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingState;
    /**
     * The BillingZip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingZip;
    /**
     * The BillingCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingCountry;
    /**
     * The OrderKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderKey;
    /**
     * Constructor method for DebitBankAccountRequest
     * @uses DebitBankAccountRequest::setBankAccountType()
     * @uses DebitBankAccountRequest::setOrderID()
     * @uses DebitBankAccountRequest::setMaxAmount()
     * @uses DebitBankAccountRequest::setBankAccountNumber()
     * @uses DebitBankAccountRequest::setBankRoutingNumber()
     * @uses DebitBankAccountRequest::setBankName()
     * @uses DebitBankAccountRequest::setCheckNumber()
     * @uses DebitBankAccountRequest::setNameOnAccount()
     * @uses DebitBankAccountRequest::setBillingAddress()
     * @uses DebitBankAccountRequest::setBillingAddress2()
     * @uses DebitBankAccountRequest::setBillingCity()
     * @uses DebitBankAccountRequest::setBillingState()
     * @uses DebitBankAccountRequest::setBillingZip()
     * @uses DebitBankAccountRequest::setBillingCountry()
     * @uses DebitBankAccountRequest::setOrderKey()
     * @param string $bankAccountType
     * @param int $orderID
     * @param float $maxAmount
     * @param string $bankAccountNumber
     * @param string $bankRoutingNumber
     * @param string $bankName
     * @param string $checkNumber
     * @param string $nameOnAccount
     * @param string $billingAddress
     * @param string $billingAddress2
     * @param string $billingCity
     * @param string $billingState
     * @param string $billingZip
     * @param string $billingCountry
     * @param string $orderKey
     */
    public function __construct($bankAccountType = null, $orderID = null, $maxAmount = null, $bankAccountNumber = null, $bankRoutingNumber = null, $bankName = null, $checkNumber = null, $nameOnAccount = null, $billingAddress = null, $billingAddress2 = null, $billingCity = null, $billingState = null, $billingZip = null, $billingCountry = null, $orderKey = null)
    {
        $this
            ->setBankAccountType($bankAccountType)
            ->setOrderID($orderID)
            ->setMaxAmount($maxAmount)
            ->setBankAccountNumber($bankAccountNumber)
            ->setBankRoutingNumber($bankRoutingNumber)
            ->setBankName($bankName)
            ->setCheckNumber($checkNumber)
            ->setNameOnAccount($nameOnAccount)
            ->setBillingAddress($billingAddress)
            ->setBillingAddress2($billingAddress2)
            ->setBillingCity($billingCity)
            ->setBillingState($billingState)
            ->setBillingZip($billingZip)
            ->setBillingCountry($billingCountry)
            ->setOrderKey($orderKey);
    }
    /**
     * Get BankAccountType value
     * @return string
     */
    public function getBankAccountType()
    {
        return $this->BankAccountType;
    }
    /**
     * Set BankAccountType value
     * @uses \EnumType\BankAccountType::valueIsValid()
     * @uses \EnumType\BankAccountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bankAccountType
     * @return \StructType\DebitBankAccountRequest
     */
    public function setBankAccountType($bankAccountType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BankAccountType::valueIsValid($bankAccountType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $bankAccountType, implode(', ', \EnumType\BankAccountType::getValidValues())), __LINE__);
        }
        $this->BankAccountType = $bankAccountType;
        return $this;
    }
    /**
     * Get OrderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param int $orderID
     * @return \StructType\DebitBankAccountRequest
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !is_numeric($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get MaxAmount value
     * @return float
     */
    public function getMaxAmount()
    {
        return $this->MaxAmount;
    }
    /**
     * Set MaxAmount value
     * @param float $maxAmount
     * @return \StructType\DebitBankAccountRequest
     */
    public function setMaxAmount($maxAmount = null)
    {
        $this->MaxAmount = $maxAmount;
        return $this;
    }
    /**
     * Get BankAccountNumber value
     * @return string|null
     */
    public function getBankAccountNumber()
    {
        return $this->BankAccountNumber;
    }
    /**
     * Set BankAccountNumber value
     * @param string $bankAccountNumber
     * @return \StructType\DebitBankAccountRequest
     */
    public function setBankAccountNumber($bankAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountNumber) && !is_string($bankAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankAccountNumber)), __LINE__);
        }
        $this->BankAccountNumber = $bankAccountNumber;
        return $this;
    }
    /**
     * Get BankRoutingNumber value
     * @return string|null
     */
    public function getBankRoutingNumber()
    {
        return $this->BankRoutingNumber;
    }
    /**
     * Set BankRoutingNumber value
     * @param string $bankRoutingNumber
     * @return \StructType\DebitBankAccountRequest
     */
    public function setBankRoutingNumber($bankRoutingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankRoutingNumber) && !is_string($bankRoutingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankRoutingNumber)), __LINE__);
        }
        $this->BankRoutingNumber = $bankRoutingNumber;
        return $this;
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->BankName;
    }
    /**
     * Set BankName value
     * @param string $bankName
     * @return \StructType\DebitBankAccountRequest
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankName)), __LINE__);
        }
        $this->BankName = $bankName;
        return $this;
    }
    /**
     * Get CheckNumber value
     * @return string|null
     */
    public function getCheckNumber()
    {
        return $this->CheckNumber;
    }
    /**
     * Set CheckNumber value
     * @param string $checkNumber
     * @return \StructType\DebitBankAccountRequest
     */
    public function setCheckNumber($checkNumber = null)
    {
        // validation for constraint: string
        if (!is_null($checkNumber) && !is_string($checkNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkNumber)), __LINE__);
        }
        $this->CheckNumber = $checkNumber;
        return $this;
    }
    /**
     * Get NameOnAccount value
     * @return string|null
     */
    public function getNameOnAccount()
    {
        return $this->NameOnAccount;
    }
    /**
     * Set NameOnAccount value
     * @param string $nameOnAccount
     * @return \StructType\DebitBankAccountRequest
     */
    public function setNameOnAccount($nameOnAccount = null)
    {
        // validation for constraint: string
        if (!is_null($nameOnAccount) && !is_string($nameOnAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameOnAccount)), __LINE__);
        }
        $this->NameOnAccount = $nameOnAccount;
        return $this;
    }
    /**
     * Get BillingAddress value
     * @return string|null
     */
    public function getBillingAddress()
    {
        return $this->BillingAddress;
    }
    /**
     * Set BillingAddress value
     * @param string $billingAddress
     * @return \StructType\DebitBankAccountRequest
     */
    public function setBillingAddress($billingAddress = null)
    {
        // validation for constraint: string
        if (!is_null($billingAddress) && !is_string($billingAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingAddress)), __LINE__);
        }
        $this->BillingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get BillingAddress2 value
     * @return string|null
     */
    public function getBillingAddress2()
    {
        return $this->BillingAddress2;
    }
    /**
     * Set BillingAddress2 value
     * @param string $billingAddress2
     * @return \StructType\DebitBankAccountRequest
     */
    public function setBillingAddress2($billingAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($billingAddress2) && !is_string($billingAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingAddress2)), __LINE__);
        }
        $this->BillingAddress2 = $billingAddress2;
        return $this;
    }
    /**
     * Get BillingCity value
     * @return string|null
     */
    public function getBillingCity()
    {
        return $this->BillingCity;
    }
    /**
     * Set BillingCity value
     * @param string $billingCity
     * @return \StructType\DebitBankAccountRequest
     */
    public function setBillingCity($billingCity = null)
    {
        // validation for constraint: string
        if (!is_null($billingCity) && !is_string($billingCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingCity)), __LINE__);
        }
        $this->BillingCity = $billingCity;
        return $this;
    }
    /**
     * Get BillingState value
     * @return string|null
     */
    public function getBillingState()
    {
        return $this->BillingState;
    }
    /**
     * Set BillingState value
     * @param string $billingState
     * @return \StructType\DebitBankAccountRequest
     */
    public function setBillingState($billingState = null)
    {
        // validation for constraint: string
        if (!is_null($billingState) && !is_string($billingState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingState)), __LINE__);
        }
        $this->BillingState = $billingState;
        return $this;
    }
    /**
     * Get BillingZip value
     * @return string|null
     */
    public function getBillingZip()
    {
        return $this->BillingZip;
    }
    /**
     * Set BillingZip value
     * @param string $billingZip
     * @return \StructType\DebitBankAccountRequest
     */
    public function setBillingZip($billingZip = null)
    {
        // validation for constraint: string
        if (!is_null($billingZip) && !is_string($billingZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingZip)), __LINE__);
        }
        $this->BillingZip = $billingZip;
        return $this;
    }
    /**
     * Get BillingCountry value
     * @return string|null
     */
    public function getBillingCountry()
    {
        return $this->BillingCountry;
    }
    /**
     * Set BillingCountry value
     * @param string $billingCountry
     * @return \StructType\DebitBankAccountRequest
     */
    public function setBillingCountry($billingCountry = null)
    {
        // validation for constraint: string
        if (!is_null($billingCountry) && !is_string($billingCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingCountry)), __LINE__);
        }
        $this->BillingCountry = $billingCountry;
        return $this;
    }
    /**
     * Get OrderKey value
     * @return string|null
     */
    public function getOrderKey()
    {
        return $this->OrderKey;
    }
    /**
     * Set OrderKey value
     * @param string $orderKey
     * @return \StructType\DebitBankAccountRequest
     */
    public function setOrderKey($orderKey = null)
    {
        // validation for constraint: string
        if (!is_null($orderKey) && !is_string($orderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderKey)), __LINE__);
        }
        $this->OrderKey = $orderKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DebitBankAccountRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
