<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSocialNetworksResponse StructType
 * @subpackage Structs
 */
class CustomerSocialNetworksResponse extends AbstractStructBase
{
    /**
     * The SocialNetworkID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SocialNetworkID;
    /**
     * The SocialNetworkDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SocialNetworkDescription;
    /**
     * The Url
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Url;
    /**
     * Constructor method for CustomerSocialNetworksResponse
     * @uses CustomerSocialNetworksResponse::setSocialNetworkID()
     * @uses CustomerSocialNetworksResponse::setSocialNetworkDescription()
     * @uses CustomerSocialNetworksResponse::setUrl()
     * @param int $socialNetworkID
     * @param string $socialNetworkDescription
     * @param string $url
     */
    public function __construct($socialNetworkID = null, $socialNetworkDescription = null, $url = null)
    {
        $this
            ->setSocialNetworkID($socialNetworkID)
            ->setSocialNetworkDescription($socialNetworkDescription)
            ->setUrl($url);
    }
    /**
     * Get SocialNetworkID value
     * @return int
     */
    public function getSocialNetworkID()
    {
        return $this->SocialNetworkID;
    }
    /**
     * Set SocialNetworkID value
     * @param int $socialNetworkID
     * @return \StructType\CustomerSocialNetworksResponse
     */
    public function setSocialNetworkID($socialNetworkID = null)
    {
        // validation for constraint: int
        if (!is_null($socialNetworkID) && !is_numeric($socialNetworkID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($socialNetworkID)), __LINE__);
        }
        $this->SocialNetworkID = $socialNetworkID;
        return $this;
    }
    /**
     * Get SocialNetworkDescription value
     * @return string|null
     */
    public function getSocialNetworkDescription()
    {
        return $this->SocialNetworkDescription;
    }
    /**
     * Set SocialNetworkDescription value
     * @param string $socialNetworkDescription
     * @return \StructType\CustomerSocialNetworksResponse
     */
    public function setSocialNetworkDescription($socialNetworkDescription = null)
    {
        // validation for constraint: string
        if (!is_null($socialNetworkDescription) && !is_string($socialNetworkDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($socialNetworkDescription)), __LINE__);
        }
        $this->SocialNetworkDescription = $socialNetworkDescription;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return \StructType\CustomerSocialNetworksResponse
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerSocialNetworksResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
