<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateWebCategoryRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:CreateWebCategoryRequest
 * @subpackage Structs
 */
class CreateWebCategoryRequest extends ApiRequest
{
    /**
     * The WebID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WebID;
    /**
     * The ParentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ParentID;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for CreateWebCategoryRequest
     * @uses CreateWebCategoryRequest::setWebID()
     * @uses CreateWebCategoryRequest::setParentID()
     * @uses CreateWebCategoryRequest::setDescription()
     * @param int $webID
     * @param int $parentID
     * @param string $description
     */
    public function __construct($webID = null, $parentID = null, $description = null)
    {
        $this
            ->setWebID($webID)
            ->setParentID($parentID)
            ->setDescription($description);
    }
    /**
     * Get WebID value
     * @return int
     */
    public function getWebID()
    {
        return $this->WebID;
    }
    /**
     * Set WebID value
     * @param int $webID
     * @return \StructType\CreateWebCategoryRequest
     */
    public function setWebID($webID = null)
    {
        // validation for constraint: int
        if (!is_null($webID) && !is_numeric($webID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($webID)), __LINE__);
        }
        $this->WebID = $webID;
        return $this;
    }
    /**
     * Get ParentID value
     * @return int
     */
    public function getParentID()
    {
        return $this->ParentID;
    }
    /**
     * Set ParentID value
     * @param int $parentID
     * @return \StructType\CreateWebCategoryRequest
     */
    public function setParentID($parentID = null)
    {
        // validation for constraint: int
        if (!is_null($parentID) && !is_numeric($parentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($parentID)), __LINE__);
        }
        $this->ParentID = $parentID;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\CreateWebCategoryRequest
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateWebCategoryRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
