<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreatePaymentCheckResponse StructType
 * @subpackage Structs
 */
class CreatePaymentCheckResponse extends BaseCreatePaymentResponse
{
    /**
     * The PaymentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentID;
    /**
     * Constructor method for CreatePaymentCheckResponse
     * @uses CreatePaymentCheckResponse::setPaymentID()
     * @param int $paymentID
     */
    public function __construct($paymentID = null)
    {
        $this
            ->setPaymentID($paymentID);
    }
    /**
     * Get PaymentID value
     * @return int
     */
    public function getPaymentID()
    {
        return $this->PaymentID;
    }
    /**
     * Set PaymentID value
     * @param int $paymentID
     * @return \StructType\CreatePaymentCheckResponse
     */
    public function setPaymentID($paymentID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentID) && !is_numeric($paymentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentID)), __LINE__);
        }
        $this->PaymentID = $paymentID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreatePaymentCheckResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
