<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateCustomerInquiryRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:CreateCustomerInquiryRequest
 * @subpackage Structs
 */
class CreateCustomerInquiryRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The CustomerInquiryStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerInquiryStatusID;
    /**
     * The CustomerInquiryCategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerInquiryCategoryID;
    /**
     * The ParentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ParentID;
    /**
     * The Detail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Detail;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The AssignToUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AssignToUser;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for CreateCustomerInquiryRequest
     * @uses CreateCustomerInquiryRequest::setCustomerID()
     * @uses CreateCustomerInquiryRequest::setCustomerInquiryStatusID()
     * @uses CreateCustomerInquiryRequest::setCustomerInquiryCategoryID()
     * @uses CreateCustomerInquiryRequest::setParentID()
     * @uses CreateCustomerInquiryRequest::setDetail()
     * @uses CreateCustomerInquiryRequest::setDescription()
     * @uses CreateCustomerInquiryRequest::setAssignToUser()
     * @uses CreateCustomerInquiryRequest::setCustomerKey()
     * @param int $customerID
     * @param int $customerInquiryStatusID
     * @param int $customerInquiryCategoryID
     * @param int $parentID
     * @param string $detail
     * @param string $description
     * @param string $assignToUser
     * @param string $customerKey
     */
    public function __construct($customerID = null, $customerInquiryStatusID = null, $customerInquiryCategoryID = null, $parentID = null, $detail = null, $description = null, $assignToUser = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setCustomerInquiryStatusID($customerInquiryStatusID)
            ->setCustomerInquiryCategoryID($customerInquiryCategoryID)
            ->setParentID($parentID)
            ->setDetail($detail)
            ->setDescription($description)
            ->setAssignToUser($assignToUser)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\CreateCustomerInquiryRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get CustomerInquiryStatusID value
     * @return int
     */
    public function getCustomerInquiryStatusID()
    {
        return $this->CustomerInquiryStatusID;
    }
    /**
     * Set CustomerInquiryStatusID value
     * @param int $customerInquiryStatusID
     * @return \StructType\CreateCustomerInquiryRequest
     */
    public function setCustomerInquiryStatusID($customerInquiryStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($customerInquiryStatusID) && !is_numeric($customerInquiryStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerInquiryStatusID)), __LINE__);
        }
        $this->CustomerInquiryStatusID = $customerInquiryStatusID;
        return $this;
    }
    /**
     * Get CustomerInquiryCategoryID value
     * @return int
     */
    public function getCustomerInquiryCategoryID()
    {
        return $this->CustomerInquiryCategoryID;
    }
    /**
     * Set CustomerInquiryCategoryID value
     * @param int $customerInquiryCategoryID
     * @return \StructType\CreateCustomerInquiryRequest
     */
    public function setCustomerInquiryCategoryID($customerInquiryCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($customerInquiryCategoryID) && !is_numeric($customerInquiryCategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerInquiryCategoryID)), __LINE__);
        }
        $this->CustomerInquiryCategoryID = $customerInquiryCategoryID;
        return $this;
    }
    /**
     * Get ParentID value
     * @return int
     */
    public function getParentID()
    {
        return $this->ParentID;
    }
    /**
     * Set ParentID value
     * @param int $parentID
     * @return \StructType\CreateCustomerInquiryRequest
     */
    public function setParentID($parentID = null)
    {
        // validation for constraint: int
        if (!is_null($parentID) && !is_numeric($parentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($parentID)), __LINE__);
        }
        $this->ParentID = $parentID;
        return $this;
    }
    /**
     * Get Detail value
     * @return string|null
     */
    public function getDetail()
    {
        return $this->Detail;
    }
    /**
     * Set Detail value
     * @param string $detail
     * @return \StructType\CreateCustomerInquiryRequest
     */
    public function setDetail($detail = null)
    {
        // validation for constraint: string
        if (!is_null($detail) && !is_string($detail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($detail)), __LINE__);
        }
        $this->Detail = $detail;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\CreateCustomerInquiryRequest
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get AssignToUser value
     * @return string|null
     */
    public function getAssignToUser()
    {
        return $this->AssignToUser;
    }
    /**
     * Set AssignToUser value
     * @param string $assignToUser
     * @return \StructType\CreateCustomerInquiryRequest
     */
    public function setAssignToUser($assignToUser = null)
    {
        // validation for constraint: string
        if (!is_null($assignToUser) && !is_string($assignToUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($assignToUser)), __LINE__);
        }
        $this->AssignToUser = $assignToUser;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\CreateCustomerInquiryRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateCustomerInquiryRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
