<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateCustomerFileResponse StructType
 * @subpackage Structs
 */
class CreateCustomerFileResponse extends ApiResponse
{
    /**
     * The FolderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FolderID;
    /**
     * The FileID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FileID;
    /**
     * Constructor method for CreateCustomerFileResponse
     * @uses CreateCustomerFileResponse::setFolderID()
     * @uses CreateCustomerFileResponse::setFileID()
     * @param int $folderID
     * @param int $fileID
     */
    public function __construct($folderID = null, $fileID = null)
    {
        $this
            ->setFolderID($folderID)
            ->setFileID($fileID);
    }
    /**
     * Get FolderID value
     * @return int
     */
    public function getFolderID()
    {
        return $this->FolderID;
    }
    /**
     * Set FolderID value
     * @param int $folderID
     * @return \StructType\CreateCustomerFileResponse
     */
    public function setFolderID($folderID = null)
    {
        // validation for constraint: int
        if (!is_null($folderID) && !is_numeric($folderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($folderID)), __LINE__);
        }
        $this->FolderID = $folderID;
        return $this;
    }
    /**
     * Get FileID value
     * @return int
     */
    public function getFileID()
    {
        return $this->FileID;
    }
    /**
     * Set FileID value
     * @param int $fileID
     * @return \StructType\CreateCustomerFileResponse
     */
    public function setFileID($fileID = null)
    {
        // validation for constraint: int
        if (!is_null($fileID) && !is_numeric($fileID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fileID)), __LINE__);
        }
        $this->FileID = $fileID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateCustomerFileResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
