<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateCustomerBalanceAdjustmentRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:CreateCustomerBalanceAdjustmentRequest
 * @subpackage Structs
 */
class CreateCustomerBalanceAdjustmentRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The CustomerTransactionTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerTransactionTypeID;
    /**
     * The TransactionDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TransactionDate;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for CreateCustomerBalanceAdjustmentRequest
     * @uses CreateCustomerBalanceAdjustmentRequest::setCustomerID()
     * @uses CreateCustomerBalanceAdjustmentRequest::setCustomerTransactionTypeID()
     * @uses CreateCustomerBalanceAdjustmentRequest::setTransactionDate()
     * @uses CreateCustomerBalanceAdjustmentRequest::setAmount()
     * @uses CreateCustomerBalanceAdjustmentRequest::setCurrencyCode()
     * @uses CreateCustomerBalanceAdjustmentRequest::setNotes()
     * @uses CreateCustomerBalanceAdjustmentRequest::setCustomerKey()
     * @param int $customerID
     * @param int $customerTransactionTypeID
     * @param string $transactionDate
     * @param float $amount
     * @param string $currencyCode
     * @param string $notes
     * @param string $customerKey
     */
    public function __construct($customerID = null, $customerTransactionTypeID = null, $transactionDate = null, $amount = null, $currencyCode = null, $notes = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setCustomerTransactionTypeID($customerTransactionTypeID)
            ->setTransactionDate($transactionDate)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setNotes($notes)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\CreateCustomerBalanceAdjustmentRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get CustomerTransactionTypeID value
     * @return int
     */
    public function getCustomerTransactionTypeID()
    {
        return $this->CustomerTransactionTypeID;
    }
    /**
     * Set CustomerTransactionTypeID value
     * @param int $customerTransactionTypeID
     * @return \StructType\CreateCustomerBalanceAdjustmentRequest
     */
    public function setCustomerTransactionTypeID($customerTransactionTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($customerTransactionTypeID) && !is_numeric($customerTransactionTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerTransactionTypeID)), __LINE__);
        }
        $this->CustomerTransactionTypeID = $customerTransactionTypeID;
        return $this;
    }
    /**
     * Get TransactionDate value
     * @return string
     */
    public function getTransactionDate()
    {
        return $this->TransactionDate;
    }
    /**
     * Set TransactionDate value
     * @param string $transactionDate
     * @return \StructType\CreateCustomerBalanceAdjustmentRequest
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionDate)), __LINE__);
        }
        $this->TransactionDate = $transactionDate;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\CreateCustomerBalanceAdjustmentRequest
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\CreateCustomerBalanceAdjustmentRequest
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \StructType\CreateCustomerBalanceAdjustmentRequest
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\CreateCustomerBalanceAdjustmentRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateCustomerBalanceAdjustmentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
