<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeCreditCardTokenOnFileRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:ChargeCreditCardTokenOnFileRequest
 * @subpackage Structs
 */
class ChargeCreditCardTokenOnFileRequest extends BaseChargeCreditCardRequest
{
    /**
     * The CreditCardAccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreditCardAccountType;
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderID;
    /**
     * The MaxAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxAmount;
    /**
     * The MerchantWarehouseIDOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MerchantWarehouseIDOverride;
    /**
     * The CvcCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CvcCode;
    /**
     * The ClientIPAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientIPAddress;
    /**
     * The OtherData1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherData1;
    /**
     * The OtherData2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherData2;
    /**
     * The OtherData3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherData3;
    /**
     * The OtherData4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherData4;
    /**
     * The OtherData5
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherData5;
    /**
     * The OtherData6
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherData6;
    /**
     * The OtherData7
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherData7;
    /**
     * The OtherData8
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherData8;
    /**
     * The OtherData9
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherData9;
    /**
     * The OtherData10
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherData10;
    /**
     * The OrderKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderKey;
    /**
     * Constructor method for ChargeCreditCardTokenOnFileRequest
     * @uses ChargeCreditCardTokenOnFileRequest::setCreditCardAccountType()
     * @uses ChargeCreditCardTokenOnFileRequest::setOrderID()
     * @uses ChargeCreditCardTokenOnFileRequest::setMaxAmount()
     * @uses ChargeCreditCardTokenOnFileRequest::setMerchantWarehouseIDOverride()
     * @uses ChargeCreditCardTokenOnFileRequest::setCvcCode()
     * @uses ChargeCreditCardTokenOnFileRequest::setClientIPAddress()
     * @uses ChargeCreditCardTokenOnFileRequest::setOtherData1()
     * @uses ChargeCreditCardTokenOnFileRequest::setOtherData2()
     * @uses ChargeCreditCardTokenOnFileRequest::setOtherData3()
     * @uses ChargeCreditCardTokenOnFileRequest::setOtherData4()
     * @uses ChargeCreditCardTokenOnFileRequest::setOtherData5()
     * @uses ChargeCreditCardTokenOnFileRequest::setOtherData6()
     * @uses ChargeCreditCardTokenOnFileRequest::setOtherData7()
     * @uses ChargeCreditCardTokenOnFileRequest::setOtherData8()
     * @uses ChargeCreditCardTokenOnFileRequest::setOtherData9()
     * @uses ChargeCreditCardTokenOnFileRequest::setOtherData10()
     * @uses ChargeCreditCardTokenOnFileRequest::setOrderKey()
     * @param string $creditCardAccountType
     * @param int $orderID
     * @param float $maxAmount
     * @param int $merchantWarehouseIDOverride
     * @param string $cvcCode
     * @param string $clientIPAddress
     * @param string $otherData1
     * @param string $otherData2
     * @param string $otherData3
     * @param string $otherData4
     * @param string $otherData5
     * @param string $otherData6
     * @param string $otherData7
     * @param string $otherData8
     * @param string $otherData9
     * @param string $otherData10
     * @param string $orderKey
     */
    public function __construct($creditCardAccountType = null, $orderID = null, $maxAmount = null, $merchantWarehouseIDOverride = null, $cvcCode = null, $clientIPAddress = null, $otherData1 = null, $otherData2 = null, $otherData3 = null, $otherData4 = null, $otherData5 = null, $otherData6 = null, $otherData7 = null, $otherData8 = null, $otherData9 = null, $otherData10 = null, $orderKey = null)
    {
        $this
            ->setCreditCardAccountType($creditCardAccountType)
            ->setOrderID($orderID)
            ->setMaxAmount($maxAmount)
            ->setMerchantWarehouseIDOverride($merchantWarehouseIDOverride)
            ->setCvcCode($cvcCode)
            ->setClientIPAddress($clientIPAddress)
            ->setOtherData1($otherData1)
            ->setOtherData2($otherData2)
            ->setOtherData3($otherData3)
            ->setOtherData4($otherData4)
            ->setOtherData5($otherData5)
            ->setOtherData6($otherData6)
            ->setOtherData7($otherData7)
            ->setOtherData8($otherData8)
            ->setOtherData9($otherData9)
            ->setOtherData10($otherData10)
            ->setOrderKey($orderKey);
    }
    /**
     * Get CreditCardAccountType value
     * @return string
     */
    public function getCreditCardAccountType()
    {
        return $this->CreditCardAccountType;
    }
    /**
     * Set CreditCardAccountType value
     * @uses \EnumType\AccountCreditCardType::valueIsValid()
     * @uses \EnumType\AccountCreditCardType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $creditCardAccountType
     * @return \StructType\ChargeCreditCardTokenOnFileRequest
     */
    public function setCreditCardAccountType($creditCardAccountType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountCreditCardType::valueIsValid($creditCardAccountType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $creditCardAccountType, implode(', ', \EnumType\AccountCreditCardType::getValidValues())), __LINE__);
        }
        $this->CreditCardAccountType = $creditCardAccountType;
        return $this;
    }
    /**
     * Get OrderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param int $orderID
     * @return \StructType\ChargeCreditCardTokenOnFileRequest
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !is_numeric($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get MaxAmount value
     * @return float
     */
    public function getMaxAmount()
    {
        return $this->MaxAmount;
    }
    /**
     * Set MaxAmount value
     * @param float $maxAmount
     * @return \StructType\ChargeCreditCardTokenOnFileRequest
     */
    public function setMaxAmount($maxAmount = null)
    {
        $this->MaxAmount = $maxAmount;
        return $this;
    }
    /**
     * Get MerchantWarehouseIDOverride value
     * @return int
     */
    public function getMerchantWarehouseIDOverride()
    {
        return $this->MerchantWarehouseIDOverride;
    }
    /**
     * Set MerchantWarehouseIDOverride value
     * @param int $merchantWarehouseIDOverride
     * @return \StructType\ChargeCreditCardTokenOnFileRequest
     */
    public function setMerchantWarehouseIDOverride($merchantWarehouseIDOverride = null)
    {
        // validation for constraint: int
        if (!is_null($merchantWarehouseIDOverride) && !is_numeric($merchantWarehouseIDOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($merchantWarehouseIDOverride)), __LINE__);
        }
        $this->MerchantWarehouseIDOverride = $merchantWarehouseIDOverride;
        return $this;
    }
    /**
     * Get CvcCode value
     * @return string|null
     */
    public function getCvcCode()
    {
        return $this->CvcCode;
    }
    /**
     * Set CvcCode value
     * @param string $cvcCode
     * @return \StructType\ChargeCreditCardTokenOnFileRequest
     */
    public function setCvcCode($cvcCode = null)
    {
        // validation for constraint: string
        if (!is_null($cvcCode) && !is_string($cvcCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cvcCode)), __LINE__);
        }
        $this->CvcCode = $cvcCode;
        return $this;
    }
    /**
     * Get ClientIPAddress value
     * @return string|null
     */
    public function getClientIPAddress()
    {
        return $this->ClientIPAddress;
    }
    /**
     * Set ClientIPAddress value
     * @param string $clientIPAddress
     * @return \StructType\ChargeCreditCardTokenOnFileRequest
     */
    public function setClientIPAddress($clientIPAddress = null)
    {
        // validation for constraint: string
        if (!is_null($clientIPAddress) && !is_string($clientIPAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientIPAddress)), __LINE__);
        }
        $this->ClientIPAddress = $clientIPAddress;
        return $this;
    }
    /**
     * Get OtherData1 value
     * @return string|null
     */
    public function getOtherData1()
    {
        return $this->OtherData1;
    }
    /**
     * Set OtherData1 value
     * @param string $otherData1
     * @return \StructType\ChargeCreditCardTokenOnFileRequest
     */
    public function setOtherData1($otherData1 = null)
    {
        // validation for constraint: string
        if (!is_null($otherData1) && !is_string($otherData1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherData1)), __LINE__);
        }
        $this->OtherData1 = $otherData1;
        return $this;
    }
    /**
     * Get OtherData2 value
     * @return string|null
     */
    public function getOtherData2()
    {
        return $this->OtherData2;
    }
    /**
     * Set OtherData2 value
     * @param string $otherData2
     * @return \StructType\ChargeCreditCardTokenOnFileRequest
     */
    public function setOtherData2($otherData2 = null)
    {
        // validation for constraint: string
        if (!is_null($otherData2) && !is_string($otherData2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherData2)), __LINE__);
        }
        $this->OtherData2 = $otherData2;
        return $this;
    }
    /**
     * Get OtherData3 value
     * @return string|null
     */
    public function getOtherData3()
    {
        return $this->OtherData3;
    }
    /**
     * Set OtherData3 value
     * @param string $otherData3
     * @return \StructType\ChargeCreditCardTokenOnFileRequest
     */
    public function setOtherData3($otherData3 = null)
    {
        // validation for constraint: string
        if (!is_null($otherData3) && !is_string($otherData3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherData3)), __LINE__);
        }
        $this->OtherData3 = $otherData3;
        return $this;
    }
    /**
     * Get OtherData4 value
     * @return string|null
     */
    public function getOtherData4()
    {
        return $this->OtherData4;
    }
    /**
     * Set OtherData4 value
     * @param string $otherData4
     * @return \StructType\ChargeCreditCardTokenOnFileRequest
     */
    public function setOtherData4($otherData4 = null)
    {
        // validation for constraint: string
        if (!is_null($otherData4) && !is_string($otherData4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherData4)), __LINE__);
        }
        $this->OtherData4 = $otherData4;
        return $this;
    }
    /**
     * Get OtherData5 value
     * @return string|null
     */
    public function getOtherData5()
    {
        return $this->OtherData5;
    }
    /**
     * Set OtherData5 value
     * @param string $otherData5
     * @return \StructType\ChargeCreditCardTokenOnFileRequest
     */
    public function setOtherData5($otherData5 = null)
    {
        // validation for constraint: string
        if (!is_null($otherData5) && !is_string($otherData5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherData5)), __LINE__);
        }
        $this->OtherData5 = $otherData5;
        return $this;
    }
    /**
     * Get OtherData6 value
     * @return string|null
     */
    public function getOtherData6()
    {
        return $this->OtherData6;
    }
    /**
     * Set OtherData6 value
     * @param string $otherData6
     * @return \StructType\ChargeCreditCardTokenOnFileRequest
     */
    public function setOtherData6($otherData6 = null)
    {
        // validation for constraint: string
        if (!is_null($otherData6) && !is_string($otherData6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherData6)), __LINE__);
        }
        $this->OtherData6 = $otherData6;
        return $this;
    }
    /**
     * Get OtherData7 value
     * @return string|null
     */
    public function getOtherData7()
    {
        return $this->OtherData7;
    }
    /**
     * Set OtherData7 value
     * @param string $otherData7
     * @return \StructType\ChargeCreditCardTokenOnFileRequest
     */
    public function setOtherData7($otherData7 = null)
    {
        // validation for constraint: string
        if (!is_null($otherData7) && !is_string($otherData7)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherData7)), __LINE__);
        }
        $this->OtherData7 = $otherData7;
        return $this;
    }
    /**
     * Get OtherData8 value
     * @return string|null
     */
    public function getOtherData8()
    {
        return $this->OtherData8;
    }
    /**
     * Set OtherData8 value
     * @param string $otherData8
     * @return \StructType\ChargeCreditCardTokenOnFileRequest
     */
    public function setOtherData8($otherData8 = null)
    {
        // validation for constraint: string
        if (!is_null($otherData8) && !is_string($otherData8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherData8)), __LINE__);
        }
        $this->OtherData8 = $otherData8;
        return $this;
    }
    /**
     * Get OtherData9 value
     * @return string|null
     */
    public function getOtherData9()
    {
        return $this->OtherData9;
    }
    /**
     * Set OtherData9 value
     * @param string $otherData9
     * @return \StructType\ChargeCreditCardTokenOnFileRequest
     */
    public function setOtherData9($otherData9 = null)
    {
        // validation for constraint: string
        if (!is_null($otherData9) && !is_string($otherData9)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherData9)), __LINE__);
        }
        $this->OtherData9 = $otherData9;
        return $this;
    }
    /**
     * Get OtherData10 value
     * @return string|null
     */
    public function getOtherData10()
    {
        return $this->OtherData10;
    }
    /**
     * Set OtherData10 value
     * @param string $otherData10
     * @return \StructType\ChargeCreditCardTokenOnFileRequest
     */
    public function setOtherData10($otherData10 = null)
    {
        // validation for constraint: string
        if (!is_null($otherData10) && !is_string($otherData10)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherData10)), __LINE__);
        }
        $this->OtherData10 = $otherData10;
        return $this;
    }
    /**
     * Get OrderKey value
     * @return string|null
     */
    public function getOrderKey()
    {
        return $this->OrderKey;
    }
    /**
     * Set OrderKey value
     * @param string $orderKey
     * @return \StructType\ChargeCreditCardTokenOnFileRequest
     */
    public function setOrderKey($orderKey = null)
    {
        // validation for constraint: string
        if (!is_null($orderKey) && !is_string($orderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderKey)), __LINE__);
        }
        $this->OrderKey = $orderKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChargeCreditCardTokenOnFileRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
