<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeAutoOrderStatusRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:ChangeAutoOrderStatusRequest
 * @subpackage Structs
 */
class ChangeAutoOrderStatusRequest extends ApiRequest
{
    /**
     * The AutoOrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AutoOrderID;
    /**
     * The AutoOrderStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AutoOrderStatus;
    /**
     * Constructor method for ChangeAutoOrderStatusRequest
     * @uses ChangeAutoOrderStatusRequest::setAutoOrderID()
     * @uses ChangeAutoOrderStatusRequest::setAutoOrderStatus()
     * @param int $autoOrderID
     * @param string $autoOrderStatus
     */
    public function __construct($autoOrderID = null, $autoOrderStatus = null)
    {
        $this
            ->setAutoOrderID($autoOrderID)
            ->setAutoOrderStatus($autoOrderStatus);
    }
    /**
     * Get AutoOrderID value
     * @return int
     */
    public function getAutoOrderID()
    {
        return $this->AutoOrderID;
    }
    /**
     * Set AutoOrderID value
     * @param int $autoOrderID
     * @return \StructType\ChangeAutoOrderStatusRequest
     */
    public function setAutoOrderID($autoOrderID = null)
    {
        // validation for constraint: int
        if (!is_null($autoOrderID) && !is_numeric($autoOrderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($autoOrderID)), __LINE__);
        }
        $this->AutoOrderID = $autoOrderID;
        return $this;
    }
    /**
     * Get AutoOrderStatus value
     * @return string
     */
    public function getAutoOrderStatus()
    {
        return $this->AutoOrderStatus;
    }
    /**
     * Set AutoOrderStatus value
     * @uses \EnumType\AutoOrderStatusType::valueIsValid()
     * @uses \EnumType\AutoOrderStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $autoOrderStatus
     * @return \StructType\ChangeAutoOrderStatusRequest
     */
    public function setAutoOrderStatus($autoOrderStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AutoOrderStatusType::valueIsValid($autoOrderStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $autoOrderStatus, implode(', ', \EnumType\AutoOrderStatusType::getValidValues())), __LINE__);
        }
        $this->AutoOrderStatus = $autoOrderStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChangeAutoOrderStatusRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
