<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankAccountResponse StructType
 * @subpackage Structs
 */
class BankAccountResponse extends AbstractStructBase
{
    /**
     * The BankAccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BankAccountType;
    /**
     * The BankAccountNumberDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankAccountNumberDisplay;
    /**
     * The BankRoutingNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankRoutingNumber;
    /**
     * The BankName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankName;
    /**
     * The NameOnAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NameOnAccount;
    /**
     * The BillingAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingAddress;
    /**
     * The BillingCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingCity;
    /**
     * The BillingState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingState;
    /**
     * The BillingZip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingZip;
    /**
     * The BillingCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingCountry;
    /**
     * The BillingAddress2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingAddress2;
    /**
     * Constructor method for BankAccountResponse
     * @uses BankAccountResponse::setBankAccountType()
     * @uses BankAccountResponse::setBankAccountNumberDisplay()
     * @uses BankAccountResponse::setBankRoutingNumber()
     * @uses BankAccountResponse::setBankName()
     * @uses BankAccountResponse::setNameOnAccount()
     * @uses BankAccountResponse::setBillingAddress()
     * @uses BankAccountResponse::setBillingCity()
     * @uses BankAccountResponse::setBillingState()
     * @uses BankAccountResponse::setBillingZip()
     * @uses BankAccountResponse::setBillingCountry()
     * @uses BankAccountResponse::setBillingAddress2()
     * @param string $bankAccountType
     * @param string $bankAccountNumberDisplay
     * @param string $bankRoutingNumber
     * @param string $bankName
     * @param string $nameOnAccount
     * @param string $billingAddress
     * @param string $billingCity
     * @param string $billingState
     * @param string $billingZip
     * @param string $billingCountry
     * @param string $billingAddress2
     */
    public function __construct($bankAccountType = null, $bankAccountNumberDisplay = null, $bankRoutingNumber = null, $bankName = null, $nameOnAccount = null, $billingAddress = null, $billingCity = null, $billingState = null, $billingZip = null, $billingCountry = null, $billingAddress2 = null)
    {
        $this
            ->setBankAccountType($bankAccountType)
            ->setBankAccountNumberDisplay($bankAccountNumberDisplay)
            ->setBankRoutingNumber($bankRoutingNumber)
            ->setBankName($bankName)
            ->setNameOnAccount($nameOnAccount)
            ->setBillingAddress($billingAddress)
            ->setBillingCity($billingCity)
            ->setBillingState($billingState)
            ->setBillingZip($billingZip)
            ->setBillingCountry($billingCountry)
            ->setBillingAddress2($billingAddress2);
    }
    /**
     * Get BankAccountType value
     * @return string
     */
    public function getBankAccountType()
    {
        return $this->BankAccountType;
    }
    /**
     * Set BankAccountType value
     * @uses \EnumType\BankAccountType::valueIsValid()
     * @uses \EnumType\BankAccountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bankAccountType
     * @return \StructType\BankAccountResponse
     */
    public function setBankAccountType($bankAccountType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BankAccountType::valueIsValid($bankAccountType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $bankAccountType, implode(', ', \EnumType\BankAccountType::getValidValues())), __LINE__);
        }
        $this->BankAccountType = $bankAccountType;
        return $this;
    }
    /**
     * Get BankAccountNumberDisplay value
     * @return string|null
     */
    public function getBankAccountNumberDisplay()
    {
        return $this->BankAccountNumberDisplay;
    }
    /**
     * Set BankAccountNumberDisplay value
     * @param string $bankAccountNumberDisplay
     * @return \StructType\BankAccountResponse
     */
    public function setBankAccountNumberDisplay($bankAccountNumberDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountNumberDisplay) && !is_string($bankAccountNumberDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankAccountNumberDisplay)), __LINE__);
        }
        $this->BankAccountNumberDisplay = $bankAccountNumberDisplay;
        return $this;
    }
    /**
     * Get BankRoutingNumber value
     * @return string|null
     */
    public function getBankRoutingNumber()
    {
        return $this->BankRoutingNumber;
    }
    /**
     * Set BankRoutingNumber value
     * @param string $bankRoutingNumber
     * @return \StructType\BankAccountResponse
     */
    public function setBankRoutingNumber($bankRoutingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankRoutingNumber) && !is_string($bankRoutingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankRoutingNumber)), __LINE__);
        }
        $this->BankRoutingNumber = $bankRoutingNumber;
        return $this;
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->BankName;
    }
    /**
     * Set BankName value
     * @param string $bankName
     * @return \StructType\BankAccountResponse
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankName)), __LINE__);
        }
        $this->BankName = $bankName;
        return $this;
    }
    /**
     * Get NameOnAccount value
     * @return string|null
     */
    public function getNameOnAccount()
    {
        return $this->NameOnAccount;
    }
    /**
     * Set NameOnAccount value
     * @param string $nameOnAccount
     * @return \StructType\BankAccountResponse
     */
    public function setNameOnAccount($nameOnAccount = null)
    {
        // validation for constraint: string
        if (!is_null($nameOnAccount) && !is_string($nameOnAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameOnAccount)), __LINE__);
        }
        $this->NameOnAccount = $nameOnAccount;
        return $this;
    }
    /**
     * Get BillingAddress value
     * @return string|null
     */
    public function getBillingAddress()
    {
        return $this->BillingAddress;
    }
    /**
     * Set BillingAddress value
     * @param string $billingAddress
     * @return \StructType\BankAccountResponse
     */
    public function setBillingAddress($billingAddress = null)
    {
        // validation for constraint: string
        if (!is_null($billingAddress) && !is_string($billingAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingAddress)), __LINE__);
        }
        $this->BillingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get BillingCity value
     * @return string|null
     */
    public function getBillingCity()
    {
        return $this->BillingCity;
    }
    /**
     * Set BillingCity value
     * @param string $billingCity
     * @return \StructType\BankAccountResponse
     */
    public function setBillingCity($billingCity = null)
    {
        // validation for constraint: string
        if (!is_null($billingCity) && !is_string($billingCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingCity)), __LINE__);
        }
        $this->BillingCity = $billingCity;
        return $this;
    }
    /**
     * Get BillingState value
     * @return string|null
     */
    public function getBillingState()
    {
        return $this->BillingState;
    }
    /**
     * Set BillingState value
     * @param string $billingState
     * @return \StructType\BankAccountResponse
     */
    public function setBillingState($billingState = null)
    {
        // validation for constraint: string
        if (!is_null($billingState) && !is_string($billingState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingState)), __LINE__);
        }
        $this->BillingState = $billingState;
        return $this;
    }
    /**
     * Get BillingZip value
     * @return string|null
     */
    public function getBillingZip()
    {
        return $this->BillingZip;
    }
    /**
     * Set BillingZip value
     * @param string $billingZip
     * @return \StructType\BankAccountResponse
     */
    public function setBillingZip($billingZip = null)
    {
        // validation for constraint: string
        if (!is_null($billingZip) && !is_string($billingZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingZip)), __LINE__);
        }
        $this->BillingZip = $billingZip;
        return $this;
    }
    /**
     * Get BillingCountry value
     * @return string|null
     */
    public function getBillingCountry()
    {
        return $this->BillingCountry;
    }
    /**
     * Set BillingCountry value
     * @param string $billingCountry
     * @return \StructType\BankAccountResponse
     */
    public function setBillingCountry($billingCountry = null)
    {
        // validation for constraint: string
        if (!is_null($billingCountry) && !is_string($billingCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingCountry)), __LINE__);
        }
        $this->BillingCountry = $billingCountry;
        return $this;
    }
    /**
     * Get BillingAddress2 value
     * @return string|null
     */
    public function getBillingAddress2()
    {
        return $this->BillingAddress2;
    }
    /**
     * Set BillingAddress2 value
     * @param string $billingAddress2
     * @return \StructType\BankAccountResponse
     */
    public function setBillingAddress2($billingAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($billingAddress2) && !is_string($billingAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingAddress2)), __LINE__);
        }
        $this->BillingAddress2 = $billingAddress2;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BankAccountResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
