<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutoOrderDetailResponse StructType
 * @subpackage Structs
 */
class AutoOrderDetailResponse extends AbstractStructBase
{
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Quantity;
    /**
     * The PriceEach
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PriceEach;
    /**
     * The PriceTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PriceTotal;
    /**
     * The BusinessVolumeEach
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BusinessVolumeEach;
    /**
     * The BusinesVolume
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BusinesVolume;
    /**
     * The CommissionableVolumeEach
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CommissionableVolumeEach;
    /**
     * The CommissionableVolume
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CommissionableVolume;
    /**
     * The PriceEachOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PriceEachOverride;
    /**
     * The TaxableEachOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TaxableEachOverride;
    /**
     * The ShippingPriceEachOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ShippingPriceEachOverride;
    /**
     * The BusinessVolumeEachOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $BusinessVolumeEachOverride;
    /**
     * The CommissionableVolumeEachOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CommissionableVolumeEachOverride;
    /**
     * The ProcessWhileDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ProcessWhileDate;
    /**
     * The SkipUntilDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SkipUntilDate;
    /**
     * The DetailStartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DetailStartDate;
    /**
     * The DetailEndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DetailEndDate;
    /**
     * The DetailInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DetailInterval;
    /**
     * The ItemCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ParentItemCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ParentItemCode;
    /**
     * The Reference1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference1;
    /**
     * Constructor method for AutoOrderDetailResponse
     * @uses AutoOrderDetailResponse::setQuantity()
     * @uses AutoOrderDetailResponse::setPriceEach()
     * @uses AutoOrderDetailResponse::setPriceTotal()
     * @uses AutoOrderDetailResponse::setBusinessVolumeEach()
     * @uses AutoOrderDetailResponse::setBusinesVolume()
     * @uses AutoOrderDetailResponse::setCommissionableVolumeEach()
     * @uses AutoOrderDetailResponse::setCommissionableVolume()
     * @uses AutoOrderDetailResponse::setPriceEachOverride()
     * @uses AutoOrderDetailResponse::setTaxableEachOverride()
     * @uses AutoOrderDetailResponse::setShippingPriceEachOverride()
     * @uses AutoOrderDetailResponse::setBusinessVolumeEachOverride()
     * @uses AutoOrderDetailResponse::setCommissionableVolumeEachOverride()
     * @uses AutoOrderDetailResponse::setProcessWhileDate()
     * @uses AutoOrderDetailResponse::setSkipUntilDate()
     * @uses AutoOrderDetailResponse::setDetailStartDate()
     * @uses AutoOrderDetailResponse::setDetailEndDate()
     * @uses AutoOrderDetailResponse::setDetailInterval()
     * @uses AutoOrderDetailResponse::setItemCode()
     * @uses AutoOrderDetailResponse::setDescription()
     * @uses AutoOrderDetailResponse::setParentItemCode()
     * @uses AutoOrderDetailResponse::setReference1()
     * @param float $quantity
     * @param float $priceEach
     * @param float $priceTotal
     * @param float $businessVolumeEach
     * @param float $businesVolume
     * @param float $commissionableVolumeEach
     * @param float $commissionableVolume
     * @param float $priceEachOverride
     * @param float $taxableEachOverride
     * @param float $shippingPriceEachOverride
     * @param float $businessVolumeEachOverride
     * @param float $commissionableVolumeEachOverride
     * @param string $processWhileDate
     * @param string $skipUntilDate
     * @param string $detailStartDate
     * @param string $detailEndDate
     * @param int $detailInterval
     * @param string $itemCode
     * @param string $description
     * @param string $parentItemCode
     * @param string $reference1
     */
    public function __construct($quantity = null, $priceEach = null, $priceTotal = null, $businessVolumeEach = null, $businesVolume = null, $commissionableVolumeEach = null, $commissionableVolume = null, $priceEachOverride = null, $taxableEachOverride = null, $shippingPriceEachOverride = null, $businessVolumeEachOverride = null, $commissionableVolumeEachOverride = null, $processWhileDate = null, $skipUntilDate = null, $detailStartDate = null, $detailEndDate = null, $detailInterval = null, $itemCode = null, $description = null, $parentItemCode = null, $reference1 = null)
    {
        $this
            ->setQuantity($quantity)
            ->setPriceEach($priceEach)
            ->setPriceTotal($priceTotal)
            ->setBusinessVolumeEach($businessVolumeEach)
            ->setBusinesVolume($businesVolume)
            ->setCommissionableVolumeEach($commissionableVolumeEach)
            ->setCommissionableVolume($commissionableVolume)
            ->setPriceEachOverride($priceEachOverride)
            ->setTaxableEachOverride($taxableEachOverride)
            ->setShippingPriceEachOverride($shippingPriceEachOverride)
            ->setBusinessVolumeEachOverride($businessVolumeEachOverride)
            ->setCommissionableVolumeEachOverride($commissionableVolumeEachOverride)
            ->setProcessWhileDate($processWhileDate)
            ->setSkipUntilDate($skipUntilDate)
            ->setDetailStartDate($detailStartDate)
            ->setDetailEndDate($detailEndDate)
            ->setDetailInterval($detailInterval)
            ->setItemCode($itemCode)
            ->setDescription($description)
            ->setParentItemCode($parentItemCode)
            ->setReference1($reference1);
    }
    /**
     * Get Quantity value
     * @return float
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\AutoOrderDetailResponse
     */
    public function setQuantity($quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get PriceEach value
     * @return float
     */
    public function getPriceEach()
    {
        return $this->PriceEach;
    }
    /**
     * Set PriceEach value
     * @param float $priceEach
     * @return \StructType\AutoOrderDetailResponse
     */
    public function setPriceEach($priceEach = null)
    {
        $this->PriceEach = $priceEach;
        return $this;
    }
    /**
     * Get PriceTotal value
     * @return float
     */
    public function getPriceTotal()
    {
        return $this->PriceTotal;
    }
    /**
     * Set PriceTotal value
     * @param float $priceTotal
     * @return \StructType\AutoOrderDetailResponse
     */
    public function setPriceTotal($priceTotal = null)
    {
        $this->PriceTotal = $priceTotal;
        return $this;
    }
    /**
     * Get BusinessVolumeEach value
     * @return float
     */
    public function getBusinessVolumeEach()
    {
        return $this->BusinessVolumeEach;
    }
    /**
     * Set BusinessVolumeEach value
     * @param float $businessVolumeEach
     * @return \StructType\AutoOrderDetailResponse
     */
    public function setBusinessVolumeEach($businessVolumeEach = null)
    {
        $this->BusinessVolumeEach = $businessVolumeEach;
        return $this;
    }
    /**
     * Get BusinesVolume value
     * @return float
     */
    public function getBusinesVolume()
    {
        return $this->BusinesVolume;
    }
    /**
     * Set BusinesVolume value
     * @param float $businesVolume
     * @return \StructType\AutoOrderDetailResponse
     */
    public function setBusinesVolume($businesVolume = null)
    {
        $this->BusinesVolume = $businesVolume;
        return $this;
    }
    /**
     * Get CommissionableVolumeEach value
     * @return float
     */
    public function getCommissionableVolumeEach()
    {
        return $this->CommissionableVolumeEach;
    }
    /**
     * Set CommissionableVolumeEach value
     * @param float $commissionableVolumeEach
     * @return \StructType\AutoOrderDetailResponse
     */
    public function setCommissionableVolumeEach($commissionableVolumeEach = null)
    {
        $this->CommissionableVolumeEach = $commissionableVolumeEach;
        return $this;
    }
    /**
     * Get CommissionableVolume value
     * @return float
     */
    public function getCommissionableVolume()
    {
        return $this->CommissionableVolume;
    }
    /**
     * Set CommissionableVolume value
     * @param float $commissionableVolume
     * @return \StructType\AutoOrderDetailResponse
     */
    public function setCommissionableVolume($commissionableVolume = null)
    {
        $this->CommissionableVolume = $commissionableVolume;
        return $this;
    }
    /**
     * Get PriceEachOverride value
     * @return float
     */
    public function getPriceEachOverride()
    {
        return $this->PriceEachOverride;
    }
    /**
     * Set PriceEachOverride value
     * @param float $priceEachOverride
     * @return \StructType\AutoOrderDetailResponse
     */
    public function setPriceEachOverride($priceEachOverride = null)
    {
        $this->PriceEachOverride = $priceEachOverride;
        return $this;
    }
    /**
     * Get TaxableEachOverride value
     * @return float
     */
    public function getTaxableEachOverride()
    {
        return $this->TaxableEachOverride;
    }
    /**
     * Set TaxableEachOverride value
     * @param float $taxableEachOverride
     * @return \StructType\AutoOrderDetailResponse
     */
    public function setTaxableEachOverride($taxableEachOverride = null)
    {
        $this->TaxableEachOverride = $taxableEachOverride;
        return $this;
    }
    /**
     * Get ShippingPriceEachOverride value
     * @return float
     */
    public function getShippingPriceEachOverride()
    {
        return $this->ShippingPriceEachOverride;
    }
    /**
     * Set ShippingPriceEachOverride value
     * @param float $shippingPriceEachOverride
     * @return \StructType\AutoOrderDetailResponse
     */
    public function setShippingPriceEachOverride($shippingPriceEachOverride = null)
    {
        $this->ShippingPriceEachOverride = $shippingPriceEachOverride;
        return $this;
    }
    /**
     * Get BusinessVolumeEachOverride value
     * @return float
     */
    public function getBusinessVolumeEachOverride()
    {
        return $this->BusinessVolumeEachOverride;
    }
    /**
     * Set BusinessVolumeEachOverride value
     * @param float $businessVolumeEachOverride
     * @return \StructType\AutoOrderDetailResponse
     */
    public function setBusinessVolumeEachOverride($businessVolumeEachOverride = null)
    {
        $this->BusinessVolumeEachOverride = $businessVolumeEachOverride;
        return $this;
    }
    /**
     * Get CommissionableVolumeEachOverride value
     * @return float
     */
    public function getCommissionableVolumeEachOverride()
    {
        return $this->CommissionableVolumeEachOverride;
    }
    /**
     * Set CommissionableVolumeEachOverride value
     * @param float $commissionableVolumeEachOverride
     * @return \StructType\AutoOrderDetailResponse
     */
    public function setCommissionableVolumeEachOverride($commissionableVolumeEachOverride = null)
    {
        $this->CommissionableVolumeEachOverride = $commissionableVolumeEachOverride;
        return $this;
    }
    /**
     * Get ProcessWhileDate value
     * @return string
     */
    public function getProcessWhileDate()
    {
        return $this->ProcessWhileDate;
    }
    /**
     * Set ProcessWhileDate value
     * @param string $processWhileDate
     * @return \StructType\AutoOrderDetailResponse
     */
    public function setProcessWhileDate($processWhileDate = null)
    {
        // validation for constraint: string
        if (!is_null($processWhileDate) && !is_string($processWhileDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($processWhileDate)), __LINE__);
        }
        $this->ProcessWhileDate = $processWhileDate;
        return $this;
    }
    /**
     * Get SkipUntilDate value
     * @return string
     */
    public function getSkipUntilDate()
    {
        return $this->SkipUntilDate;
    }
    /**
     * Set SkipUntilDate value
     * @param string $skipUntilDate
     * @return \StructType\AutoOrderDetailResponse
     */
    public function setSkipUntilDate($skipUntilDate = null)
    {
        // validation for constraint: string
        if (!is_null($skipUntilDate) && !is_string($skipUntilDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($skipUntilDate)), __LINE__);
        }
        $this->SkipUntilDate = $skipUntilDate;
        return $this;
    }
    /**
     * Get DetailStartDate value
     * @return string
     */
    public function getDetailStartDate()
    {
        return $this->DetailStartDate;
    }
    /**
     * Set DetailStartDate value
     * @param string $detailStartDate
     * @return \StructType\AutoOrderDetailResponse
     */
    public function setDetailStartDate($detailStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($detailStartDate) && !is_string($detailStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($detailStartDate)), __LINE__);
        }
        $this->DetailStartDate = $detailStartDate;
        return $this;
    }
    /**
     * Get DetailEndDate value
     * @return string
     */
    public function getDetailEndDate()
    {
        return $this->DetailEndDate;
    }
    /**
     * Set DetailEndDate value
     * @param string $detailEndDate
     * @return \StructType\AutoOrderDetailResponse
     */
    public function setDetailEndDate($detailEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($detailEndDate) && !is_string($detailEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($detailEndDate)), __LINE__);
        }
        $this->DetailEndDate = $detailEndDate;
        return $this;
    }
    /**
     * Get DetailInterval value
     * @return int
     */
    public function getDetailInterval()
    {
        return $this->DetailInterval;
    }
    /**
     * Set DetailInterval value
     * @param int $detailInterval
     * @return \StructType\AutoOrderDetailResponse
     */
    public function setDetailInterval($detailInterval = null)
    {
        // validation for constraint: int
        if (!is_null($detailInterval) && !is_numeric($detailInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($detailInterval)), __LINE__);
        }
        $this->DetailInterval = $detailInterval;
        return $this;
    }
    /**
     * Get ItemCode value
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }
    /**
     * Set ItemCode value
     * @param string $itemCode
     * @return \StructType\AutoOrderDetailResponse
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemCode)), __LINE__);
        }
        $this->ItemCode = $itemCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\AutoOrderDetailResponse
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ParentItemCode value
     * @return string|null
     */
    public function getParentItemCode()
    {
        return $this->ParentItemCode;
    }
    /**
     * Set ParentItemCode value
     * @param string $parentItemCode
     * @return \StructType\AutoOrderDetailResponse
     */
    public function setParentItemCode($parentItemCode = null)
    {
        // validation for constraint: string
        if (!is_null($parentItemCode) && !is_string($parentItemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parentItemCode)), __LINE__);
        }
        $this->ParentItemCode = $parentItemCode;
        return $this;
    }
    /**
     * Get Reference1 value
     * @return string|null
     */
    public function getReference1()
    {
        return $this->Reference1;
    }
    /**
     * Set Reference1 value
     * @param string $reference1
     * @return \StructType\AutoOrderDetailResponse
     */
    public function setReference1($reference1 = null)
    {
        // validation for constraint: string
        if (!is_null($reference1) && !is_string($reference1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference1)), __LINE__);
        }
        $this->Reference1 = $reference1;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AutoOrderDetailResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
