<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApiResult StructType
 * @subpackage Structs
 */
class ApiResult extends AbstractStructBase
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Errors;
    /**
     * The TransactionKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionKey;
    /**
     * Constructor method for ApiResult
     * @uses ApiResult::setStatus()
     * @uses ApiResult::setErrors()
     * @uses ApiResult::setTransactionKey()
     * @param string $status
     * @param \ArrayType\ArrayOfString $errors
     * @param string $transactionKey
     */
    public function __construct($status = null, \ArrayType\ArrayOfString $errors = null, $transactionKey = null)
    {
        $this
            ->setStatus($status)
            ->setErrors($errors)
            ->setTransactionKey($transactionKey);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\ResultStatus::valueIsValid()
     * @uses \EnumType\ResultStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\ApiResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ResultStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\ResultStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Errors value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \ArrayType\ArrayOfString $errors
     * @return \StructType\ApiResult
     */
    public function setErrors(\ArrayType\ArrayOfString $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get TransactionKey value
     * @return string|null
     */
    public function getTransactionKey()
    {
        return $this->TransactionKey;
    }
    /**
     * Set TransactionKey value
     * @param string $transactionKey
     * @return \StructType\ApiResult
     */
    public function setTransactionKey($transactionKey = null)
    {
        // validation for constraint: string
        if (!is_null($transactionKey) && !is_string($transactionKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionKey)), __LINE__);
        }
        $this->TransactionKey = $transactionKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ApiResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
