<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdjustInventoryRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:AdjustInventoryRequest
 * @subpackage Structs
 */
class AdjustInventoryRequest extends ApiRequest
{
    /**
     * The WarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WarehouseID;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Quantity;
    /**
     * The ItemCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemCode;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * Constructor method for AdjustInventoryRequest
     * @uses AdjustInventoryRequest::setWarehouseID()
     * @uses AdjustInventoryRequest::setQuantity()
     * @uses AdjustInventoryRequest::setItemCode()
     * @uses AdjustInventoryRequest::setNotes()
     * @param int $warehouseID
     * @param int $quantity
     * @param string $itemCode
     * @param string $notes
     */
    public function __construct($warehouseID = null, $quantity = null, $itemCode = null, $notes = null)
    {
        $this
            ->setWarehouseID($warehouseID)
            ->setQuantity($quantity)
            ->setItemCode($itemCode)
            ->setNotes($notes);
    }
    /**
     * Get WarehouseID value
     * @return int
     */
    public function getWarehouseID()
    {
        return $this->WarehouseID;
    }
    /**
     * Set WarehouseID value
     * @param int $warehouseID
     * @return \StructType\AdjustInventoryRequest
     */
    public function setWarehouseID($warehouseID = null)
    {
        // validation for constraint: int
        if (!is_null($warehouseID) && !is_numeric($warehouseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($warehouseID)), __LINE__);
        }
        $this->WarehouseID = $warehouseID;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\AdjustInventoryRequest
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get ItemCode value
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }
    /**
     * Set ItemCode value
     * @param string $itemCode
     * @return \StructType\AdjustInventoryRequest
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemCode)), __LINE__);
        }
        $this->ItemCode = $itemCode;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \StructType\AdjustInventoryRequest
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdjustInventoryRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
