<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Sets the ApiAuthentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ApiAuthentication $apiAuthentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApiAuthentication(\StructType\ApiAuthentication $apiAuthentication, $nameSpace = 'http://api.exigo.com/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ApiAuthentication', $apiAuthentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named UpdateCalendarItem
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Updates calendar item information.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCalendarItemRequest $updateCalendarItemRequest
     * @return \StructType\UpdateCalendarItemResponse|bool
     */
    public function UpdateCalendarItem(\StructType\UpdateCalendarItemRequest $updateCalendarItemRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateCalendarItem($updateCalendarItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomer
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Updates one or more fields on an existing customer. Can participate in a transaction.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCustomerRequest $updateCustomerRequest
     * @return \StructType\UpdateCustomerResponse|bool
     */
    public function UpdateCustomer(\StructType\UpdateCustomerRequest $updateCustomerRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateCustomer($updateCustomerRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomerContact
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Updates customer contact information.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCustomerContactRequest $updateCustomerContactRequest
     * @return \StructType\UpdateCustomerContactResponse|bool
     */
    public function UpdateCustomerContact(\StructType\UpdateCustomerContactRequest $updateCustomerContactRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateCustomerContact($updateCustomerContactRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomerExtended
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Updates one customer extended record.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCustomerExtendedRequest $updateCustomerExtendedRequest
     * @return \StructType\UpdateCustomerExtendedResponse|bool
     */
    public function UpdateCustomerExtended(\StructType\UpdateCustomerExtendedRequest $updateCustomerExtendedRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateCustomerExtended($updateCustomerExtendedRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomerLead
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Updates a customer leads.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCustomerLeadRequest $updateCustomerLeadRequest
     * @return \StructType\UpdateCustomerLeadResponse|bool
     */
    public function UpdateCustomerLead(\StructType\UpdateCustomerLeadRequest $updateCustomerLeadRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateCustomerLead($updateCustomerLeadRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateEmailStatus
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Updates email's status.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateEmailStatusRequest $updateEmailStatusRequest
     * @return \StructType\UpdateEmailStatusResponse|bool
     */
    public function UpdateEmailStatus(\StructType\UpdateEmailStatusRequest $updateEmailStatusRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateEmailStatus($updateEmailStatusRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateEmailTemplate
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Updates an email template.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateEmailTemplateRequest $updateEmailTemplateRequest
     * @return \StructType\UpdateEmailTemplateResponse|bool
     */
    public function UpdateEmailTemplate(\StructType\UpdateEmailTemplateRequest $updateEmailTemplateRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateEmailTemplate($updateEmailTemplateRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateExtendedDbEntity
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Update Extended DB Entity.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateEntityRequest $updateEntityRequest
     * @return \StructType\UpdateEntityResponse|bool
     */
    public function UpdateExtendedDbEntity(\StructType\UpdateEntityRequest $updateEntityRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateExtendedDbEntity($updateEntityRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateGuest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Updates one or more fields on an existing guest.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateGuestRequest $updateGuestRequest
     * @return \StructType\UpdateGuestResponse|bool
     */
    public function UpdateGuest(\StructType\UpdateGuestRequest $updateGuestRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateGuest($updateGuestRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateItem
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Updates an Item (and optional warehouse/price info)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateItemRequest $updateItemRequest
     * @return \StructType\UpdateItemResponse|bool
     */
    public function UpdateItem(\StructType\UpdateItemRequest $updateItemRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateItem($updateItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateMailFolder
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Updates a mail folder.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateMailFolderRequest $updateMailFolderRequest
     * @return \StructType\UpdateMailFolderResponse|bool
     */
    public function UpdateMailFolder(\StructType\UpdateMailFolderRequest $updateMailFolderRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateMailFolder($updateMailFolderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateOrder
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Updates one or more fields on an existing order. Can participate in a transaction.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateOrderRequest $updateOrderRequest
     * @return \StructType\UpdateOrderResponse|bool
     */
    public function UpdateOrder(\StructType\UpdateOrderRequest $updateOrderRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateOrder($updateOrderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateOrderDetail
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Update an existing Order Detail for an existing order without recalculating. Can participate in a transaction.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateOrderDetailRequest $updateOrderDetailRequest
     * @return \StructType\UpdateOrderDetailResponse|bool
     */
    public function UpdateOrderDetail(\StructType\UpdateOrderDetailRequest $updateOrderDetailRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateOrderDetail($updateOrderDetailRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateParty
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Updates selected Party instance
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdatePartyRequest $updatePartyRequest
     * @return \StructType\UpdatePartyResponse|bool
     */
    public function UpdateParty(\StructType\UpdatePartyRequest $updatePartyRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateParty($updatePartyRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateWebCategory
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Updates web category information.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateWebCategoryRequest $updateWebCategoryRequest
     * @return \StructType\UpdateWebCategoryResponse|bool
     */
    public function UpdateWebCategory(\StructType\UpdateWebCategoryRequest $updateWebCategoryRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateWebCategory($updateWebCategoryRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateAutoOrder
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Update a Recurring Order template in or out of a transaction. Client provides schedule, item codes, quantity, and shipping info. Server calculates and commits data, then pricing, tax, shipping and volume info.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateAutoOrderRequest $updateAutoOrderRequest
     * @return \StructType\UpdateAutoOrderResponse|bool
     */
    public function UpdateAutoOrder(\StructType\UpdateAutoOrderRequest $updateAutoOrderRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateAutoOrder($updateAutoOrderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateAutoOrderDetail
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Update a Recurring Order template detail in or out of a transaction. Client provides quantity, pricing , volume and extended detail info.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateAutoOrderDetailRequest $updateAutoOrderDetailRequest
     * @return \StructType\UpdateAutoOrderDetailResponse|bool
     */
    public function UpdateAutoOrderDetail(\StructType\UpdateAutoOrderDetailRequest $updateAutoOrderDetailRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateAutoOrderDetail($updateAutoOrderDetailRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateAutoOrderDetailResponse|\StructType\UpdateAutoOrderResponse|\StructType\UpdateCalendarItemResponse|\StructType\UpdateCustomerContactResponse|\StructType\UpdateCustomerExtendedResponse|\StructType\UpdateCustomerLeadResponse|\StructType\UpdateCustomerResponse|\StructType\UpdateEmailStatusResponse|\StructType\UpdateEmailTemplateResponse|\StructType\UpdateEntityResponse|\StructType\UpdateGuestResponse|\StructType\UpdateItemResponse|\StructType\UpdateMailFolderResponse|\StructType\UpdateOrderDetailResponse|\StructType\UpdateOrderResponse|\StructType\UpdatePartyResponse|\StructType\UpdateWebCategoryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
