<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Stop ServiceType
 * @subpackage Services
 */
class Stop extends AbstractSoapClientBase
{
    /**
     * Sets the ApiAuthentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ApiAuthentication $apiAuthentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApiAuthentication(\StructType\ApiAuthentication $apiAuthentication, $nameSpace = 'http://api.exigo.com/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ApiAuthentication', $apiAuthentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named StopSandbox
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Stop a Sandbox
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\StopSandboxRequest $stopSandboxRequest
     * @return \StructType\StopSandboxResponse|bool
     */
    public function StopSandbox(\StructType\StopSandboxRequest $stopSandboxRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->StopSandbox($stopSandboxRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\StopSandboxResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
