<?php

namespace EnumType;

/**
 * This class stands for TreeType EnumType
 * @subpackage Enumerations
 */
class TreeType
{
    /**
     * Constant for value 'Enroller'
     * @return string 'Enroller'
     */
    const VALUE_ENROLLER = 'Enroller';
    /**
     * Constant for value 'UniLevel'
     * @return string 'UniLevel'
     */
    const VALUE_UNI_LEVEL = 'UniLevel';
    /**
     * Constant for value 'Binary'
     * @return string 'Binary'
     */
    const VALUE_BINARY = 'Binary';
    /**
     * Constant for value 'Matrix'
     * @return string 'Matrix'
     */
    const VALUE_MATRIX = 'Matrix';
    /**
     * Constant for value 'Stack'
     * @return string 'Stack'
     */
    const VALUE_STACK = 'Stack';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ENROLLER
     * @uses self::VALUE_UNI_LEVEL
     * @uses self::VALUE_BINARY
     * @uses self::VALUE_MATRIX
     * @uses self::VALUE_STACK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ENROLLER,
            self::VALUE_UNI_LEVEL,
            self::VALUE_BINARY,
            self::VALUE_MATRIX,
            self::VALUE_STACK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
