<?php

namespace EnumType;

/**
 * This class stands for PointTransactionType EnumType
 * @subpackage Enumerations
 */
class PointTransactionType
{
    /**
     * Constant for value 'Redemption'
     * @return string 'Redemption'
     */
    const VALUE_REDEMPTION = 'Redemption';
    /**
     * Constant for value 'Adjustment'
     * @return string 'Adjustment'
     */
    const VALUE_ADJUSTMENT = 'Adjustment';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REDEMPTION
     * @uses self::VALUE_ADJUSTMENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REDEMPTION,
            self::VALUE_ADJUSTMENT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
