<?php

namespace EnumType;

/**
 * This class stands for PayableType EnumType
 * @subpackage Enumerations
 */
class PayableType
{
    /**
     * Constant for value 'Check'
     * @return string 'Check'
     */
    const VALUE_CHECK = 'Check';
    /**
     * Constant for value 'WireTransfer'
     * @return string 'WireTransfer'
     */
    const VALUE_WIRE_TRANSFER = 'WireTransfer';
    /**
     * Constant for value 'PaymentCard'
     * @return string 'PaymentCard'
     */
    const VALUE_PAYMENT_CARD = 'PaymentCard';
    /**
     * Constant for value 'DirectDeposit'
     * @return string 'DirectDeposit'
     */
    const VALUE_DIRECT_DEPOSIT = 'DirectDeposit';
    /**
     * Constant for value 'OnHold'
     * @return string 'OnHold'
     */
    const VALUE_ON_HOLD = 'OnHold';
    /**
     * Constant for value 'BankWire'
     * @return string 'BankWire'
     */
    const VALUE_BANK_WIRE = 'BankWire';
    /**
     * Constant for value 'DebitCardHold'
     * @return string 'DebitCardHold'
     */
    const VALUE_DEBIT_CARD_HOLD = 'DebitCardHold';
    /**
     * Constant for value 'Other100'
     * @return string 'Other100'
     */
    const VALUE_OTHER_100 = 'Other100';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CHECK
     * @uses self::VALUE_WIRE_TRANSFER
     * @uses self::VALUE_PAYMENT_CARD
     * @uses self::VALUE_DIRECT_DEPOSIT
     * @uses self::VALUE_ON_HOLD
     * @uses self::VALUE_BANK_WIRE
     * @uses self::VALUE_DEBIT_CARD_HOLD
     * @uses self::VALUE_OTHER_100
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CHECK,
            self::VALUE_WIRE_TRANSFER,
            self::VALUE_PAYMENT_CARD,
            self::VALUE_DIRECT_DEPOSIT,
            self::VALUE_ON_HOLD,
            self::VALUE_BANK_WIRE,
            self::VALUE_DEBIT_CARD_HOLD,
            self::VALUE_OTHER_100,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
