<?php

namespace EnumType;

/**
 * This class stands for OrderType EnumType
 * @subpackage Enumerations
 */
class OrderType
{
    /**
     * Constant for value 'Default'
     * @return string 'Default'
     */
    const VALUE_DEFAULT = 'Default';
    /**
     * Constant for value 'CustomerService'
     * @return string 'CustomerService'
     */
    const VALUE_CUSTOMER_SERVICE = 'CustomerService';
    /**
     * Constant for value 'ShoppingCart'
     * @return string 'ShoppingCart'
     */
    const VALUE_SHOPPING_CART = 'ShoppingCart';
    /**
     * Constant for value 'WebWizard'
     * @return string 'WebWizard'
     */
    const VALUE_WEB_WIZARD = 'WebWizard';
    /**
     * Constant for value 'AutoOrder'
     * @return string 'AutoOrder'
     */
    const VALUE_AUTO_ORDER = 'AutoOrder';
    /**
     * Constant for value 'Import'
     * @return string 'Import'
     */
    const VALUE_IMPORT = 'Import';
    /**
     * Constant for value 'BackOrder'
     * @return string 'BackOrder'
     */
    const VALUE_BACK_ORDER = 'BackOrder';
    /**
     * Constant for value 'ReplacementOrder'
     * @return string 'ReplacementOrder'
     */
    const VALUE_REPLACEMENT_ORDER = 'ReplacementOrder';
    /**
     * Constant for value 'ReturnOrder'
     * @return string 'ReturnOrder'
     */
    const VALUE_RETURN_ORDER = 'ReturnOrder';
    /**
     * Constant for value 'WebAutoOrder'
     * @return string 'WebAutoOrder'
     */
    const VALUE_WEB_AUTO_ORDER = 'WebAutoOrder';
    /**
     * Constant for value 'TicketSystem'
     * @return string 'TicketSystem'
     */
    const VALUE_TICKET_SYSTEM = 'TicketSystem';
    /**
     * Constant for value 'APIOrder'
     * @return string 'APIOrder'
     */
    const VALUE_APIORDER = 'APIOrder';
    /**
     * Constant for value 'BackOrderParent'
     * @return string 'BackOrderParent'
     */
    const VALUE_BACK_ORDER_PARENT = 'BackOrderParent';
    /**
     * Constant for value 'ChildOrder'
     * @return string 'ChildOrder'
     */
    const VALUE_CHILD_ORDER = 'ChildOrder';
    /**
     * Constant for value 'Other1'
     * @return string 'Other1'
     */
    const VALUE_OTHER_1 = 'Other1';
    /**
     * Constant for value 'Other2'
     * @return string 'Other2'
     */
    const VALUE_OTHER_2 = 'Other2';
    /**
     * Constant for value 'Other3'
     * @return string 'Other3'
     */
    const VALUE_OTHER_3 = 'Other3';
    /**
     * Constant for value 'Other4'
     * @return string 'Other4'
     */
    const VALUE_OTHER_4 = 'Other4';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEFAULT
     * @uses self::VALUE_CUSTOMER_SERVICE
     * @uses self::VALUE_SHOPPING_CART
     * @uses self::VALUE_WEB_WIZARD
     * @uses self::VALUE_AUTO_ORDER
     * @uses self::VALUE_IMPORT
     * @uses self::VALUE_BACK_ORDER
     * @uses self::VALUE_REPLACEMENT_ORDER
     * @uses self::VALUE_RETURN_ORDER
     * @uses self::VALUE_WEB_AUTO_ORDER
     * @uses self::VALUE_TICKET_SYSTEM
     * @uses self::VALUE_APIORDER
     * @uses self::VALUE_BACK_ORDER_PARENT
     * @uses self::VALUE_CHILD_ORDER
     * @uses self::VALUE_OTHER_1
     * @uses self::VALUE_OTHER_2
     * @uses self::VALUE_OTHER_3
     * @uses self::VALUE_OTHER_4
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEFAULT,
            self::VALUE_CUSTOMER_SERVICE,
            self::VALUE_SHOPPING_CART,
            self::VALUE_WEB_WIZARD,
            self::VALUE_AUTO_ORDER,
            self::VALUE_IMPORT,
            self::VALUE_BACK_ORDER,
            self::VALUE_REPLACEMENT_ORDER,
            self::VALUE_RETURN_ORDER,
            self::VALUE_WEB_AUTO_ORDER,
            self::VALUE_TICKET_SYSTEM,
            self::VALUE_APIORDER,
            self::VALUE_BACK_ORDER_PARENT,
            self::VALUE_CHILD_ORDER,
            self::VALUE_OTHER_1,
            self::VALUE_OTHER_2,
            self::VALUE_OTHER_3,
            self::VALUE_OTHER_4,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
