<?php

namespace EnumType;

/**
 * This class stands for OrderShipCarrier EnumType
 * @subpackage Enumerations
 */
class OrderShipCarrier
{
    /**
     * Constant for value 'FedEx'
     * @return string 'FedEx'
     */
    const VALUE_FED_EX = 'FedEx';
    /**
     * Constant for value 'UPS'
     * @return string 'UPS'
     */
    const VALUE_UPS = 'UPS';
    /**
     * Constant for value 'Purolator'
     * @return string 'Purolator'
     */
    const VALUE_PUROLATOR = 'Purolator';
    /**
     * Constant for value 'CanadaPostRegular'
     * @return string 'CanadaPostRegular'
     */
    const VALUE_CANADA_POST_REGULAR = 'CanadaPostRegular';
    /**
     * Constant for value 'CanadaPostExpress'
     * @return string 'CanadaPostExpress'
     */
    const VALUE_CANADA_POST_EXPRESS = 'CanadaPostExpress';
    /**
     * Constant for value 'DHL'
     * @return string 'DHL'
     */
    const VALUE_DHL = 'DHL';
    /**
     * Constant for value 'USPS'
     * @return string 'USPS'
     */
    const VALUE_USPS = 'USPS';
    /**
     * Constant for value 'Estafeta'
     * @return string 'Estafeta'
     */
    const VALUE_ESTAFETA = 'Estafeta';
    /**
     * Constant for value 'RoyalMail'
     * @return string 'RoyalMail'
     */
    const VALUE_ROYAL_MAIL = 'RoyalMail';
    /**
     * Constant for value 'GLSHungary'
     * @return string 'GLSHungary'
     */
    const VALUE_GLSHUNGARY = 'GLSHungary';
    /**
     * Constant for value 'PostenNorway'
     * @return string 'PostenNorway'
     */
    const VALUE_POSTEN_NORWAY = 'PostenNorway';
    /**
     * Constant for value 'LandMarkGlobal'
     * @return string 'LandMarkGlobal'
     */
    const VALUE_LAND_MARK_GLOBAL = 'LandMarkGlobal';
    /**
     * Constant for value 'GDEX'
     * @return string 'GDEX'
     */
    const VALUE_GDEX = 'GDEX';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FED_EX
     * @uses self::VALUE_UPS
     * @uses self::VALUE_PUROLATOR
     * @uses self::VALUE_CANADA_POST_REGULAR
     * @uses self::VALUE_CANADA_POST_EXPRESS
     * @uses self::VALUE_DHL
     * @uses self::VALUE_USPS
     * @uses self::VALUE_ESTAFETA
     * @uses self::VALUE_ROYAL_MAIL
     * @uses self::VALUE_GLSHUNGARY
     * @uses self::VALUE_POSTEN_NORWAY
     * @uses self::VALUE_LAND_MARK_GLOBAL
     * @uses self::VALUE_GDEX
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FED_EX,
            self::VALUE_UPS,
            self::VALUE_PUROLATOR,
            self::VALUE_CANADA_POST_REGULAR,
            self::VALUE_CANADA_POST_EXPRESS,
            self::VALUE_DHL,
            self::VALUE_USPS,
            self::VALUE_ESTAFETA,
            self::VALUE_ROYAL_MAIL,
            self::VALUE_GLSHUNGARY,
            self::VALUE_POSTEN_NORWAY,
            self::VALUE_LAND_MARK_GLOBAL,
            self::VALUE_GDEX,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
