<?php

namespace EnumType;

/**
 * This class stands for InvoiceRenderFormat EnumType
 * @subpackage Enumerations
 */
class InvoiceRenderFormat
{
    /**
     * Constant for value 'HTML'
     * @return string 'HTML'
     */
    const VALUE_HTML = 'HTML';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HTML
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HTML,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
