<?php

namespace EnumType;

/**
 * This class stands for InventoryStatusType EnumType
 * @subpackage Enumerations
 */
class InventoryStatusType
{
    /**
     * Constant for value 'Available'
     * @return string 'Available'
     */
    const VALUE_AVAILABLE = 'Available';
    /**
     * Constant for value 'OnBackOrder'
     * @return string 'OnBackOrder'
     */
    const VALUE_ON_BACK_ORDER = 'OnBackOrder';
    /**
     * Constant for value 'OutOfStock'
     * @return string 'OutOfStock'
     */
    const VALUE_OUT_OF_STOCK = 'OutOfStock';
    /**
     * Constant for value 'Discontinued'
     * @return string 'Discontinued'
     */
    const VALUE_DISCONTINUED = 'Discontinued';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AVAILABLE
     * @uses self::VALUE_ON_BACK_ORDER
     * @uses self::VALUE_OUT_OF_STOCK
     * @uses self::VALUE_DISCONTINUED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AVAILABLE,
            self::VALUE_ON_BACK_ORDER,
            self::VALUE_OUT_OF_STOCK,
            self::VALUE_DISCONTINUED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
